/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.util.LevelToSyslogSeverity;
import ch.qos.logback.core.encoder.EncoderBase;
import de.siegmar.logbackgelf.GelfFieldMapper;
import de.siegmar.logbackgelf.GelfMessage;
import de.siegmar.logbackgelf.InetUtil;
import de.siegmar.logbackgelf.mappers.CallerDataFieldMapper;
import de.siegmar.logbackgelf.mappers.MarkerFieldMapper;
import de.siegmar.logbackgelf.mappers.MdcDataFieldMapper;
import de.siegmar.logbackgelf.mappers.RootExceptionDataFieldMapper;
import de.siegmar.logbackgelf.mappers.SimpleFieldMapper;
import java.math.BigDecimal;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class GelfEncoder
extends EncoderBase<ILoggingEvent> {
    private static final Pattern VALID_ADDITIONAL_FIELD_PATTERN = Pattern.compile("^[\\w.-]*$");
    private static final String DEFAULT_SHORT_PATTERN = "%m%nopex";
    private static final String DEFAULT_FULL_PATTERN = "%m%n";
    private String originHost;
    private boolean includeRawMessage;
    private boolean includeMarker = true;
    private boolean includeMdcData = true;
    private boolean includeCallerData;
    private boolean includeRootCauseData;
    private boolean includeLevelName;
    private String levelNameKey = "level_name";
    private String loggerNameKey = "logger_name";
    private String threadNameKey = "thread_name";
    private boolean appendNewline;
    private PatternLayout shortPatternLayout;
    private PatternLayout fullPatternLayout;
    private boolean numbersAsString;
    private final Map<String, Object> staticFields = new HashMap<String, Object>();
    private final List<GelfFieldMapper<?>> builtInFieldMappers = new ArrayList();
    private final List<GelfFieldMapper<?>> fieldMappers = new ArrayList();

    public String getOriginHost() {
        return this.originHost;
    }

    public void setOriginHost(String originHost) {
        this.originHost = originHost;
    }

    public boolean isIncludeRawMessage() {
        return this.includeRawMessage;
    }

    public void setIncludeRawMessage(boolean includeRawMessage) {
        this.includeRawMessage = includeRawMessage;
    }

    public boolean isIncludeMarker() {
        return this.includeMarker;
    }

    public void setIncludeMarker(boolean includeMarker) {
        this.includeMarker = includeMarker;
    }

    public boolean isIncludeMdcData() {
        return this.includeMdcData;
    }

    public void setIncludeMdcData(boolean includeMdcData) {
        this.includeMdcData = includeMdcData;
    }

    public boolean isIncludeCallerData() {
        return this.includeCallerData;
    }

    public void setIncludeCallerData(boolean includeCallerData) {
        this.includeCallerData = includeCallerData;
    }

    public boolean isIncludeRootCauseData() {
        return this.includeRootCauseData;
    }

    public void setIncludeRootCauseData(boolean includeRootCauseData) {
        this.includeRootCauseData = includeRootCauseData;
    }

    public boolean isIncludeLevelName() {
        return this.includeLevelName;
    }

    public void setIncludeLevelName(boolean includeLevelName) {
        this.includeLevelName = includeLevelName;
    }

    public String getLevelNameKey() {
        return this.levelNameKey;
    }

    public void setLevelNameKey(String levelNameKey) {
        this.levelNameKey = levelNameKey;
    }

    public String getLoggerNameKey() {
        return this.loggerNameKey;
    }

    public void setLoggerNameKey(String loggerNameKey) {
        this.loggerNameKey = loggerNameKey;
    }

    public String getThreadNameKey() {
        return this.threadNameKey;
    }

    public void setThreadNameKey(String threadNameKey) {
        this.threadNameKey = threadNameKey;
    }

    public boolean isAppendNewline() {
        return this.appendNewline;
    }

    public void setAppendNewline(boolean appendNewline) {
        this.appendNewline = appendNewline;
    }

    public boolean isNumbersAsString() {
        return this.numbersAsString;
    }

    public void setNumbersAsString(boolean numbersAsString) {
        this.numbersAsString = numbersAsString;
    }

    public PatternLayout getShortPatternLayout() {
        return this.shortPatternLayout;
    }

    public void setShortPatternLayout(PatternLayout shortPatternLayout) {
        this.shortPatternLayout = shortPatternLayout;
    }

    public PatternLayout getFullPatternLayout() {
        return this.fullPatternLayout;
    }

    public void setFullPatternLayout(PatternLayout fullPatternLayout) {
        this.fullPatternLayout = fullPatternLayout;
    }

    public Map<String, Object> getStaticFields() {
        return Collections.unmodifiableMap(this.staticFields);
    }

    public void addStaticField(String staticField) {
        String[] split = staticField.split(":", 2);
        if (split.length != 2) {
            this.addWarn("staticField must be in format key:value - rejecting '" + staticField + "'");
            return;
        }
        try {
            this.addField(this.staticFields, split[0].trim(), split[1].trim());
        }
        catch (IllegalArgumentException e) {
            this.addWarn("Could not add field " + staticField, e);
        }
    }

    public List<GelfFieldMapper<?>> getFieldMappers() {
        return Collections.unmodifiableList(this.fieldMappers);
    }

    public void addFieldMapper(GelfFieldMapper<?> fieldMapper) {
        this.fieldMappers.add(fieldMapper);
    }

    private void addField(Map<String, Object> dst, String fieldName, Object fieldValue) {
        if (fieldName.isEmpty()) {
            throw new IllegalArgumentException("fieldName key must not be empty");
        }
        if ("id".equalsIgnoreCase(fieldName)) {
            throw new IllegalArgumentException("fieldName key name 'id' is prohibited");
        }
        if (!VALID_ADDITIONAL_FIELD_PATTERN.matcher(fieldName).matches()) {
            throw new IllegalArgumentException("fieldName key '" + fieldName + "' is illegal. Keys must apply to regex " + VALID_ADDITIONAL_FIELD_PATTERN);
        }
        Object oldValue = dst.putIfAbsent(fieldName, this.convertToNumberIfNeeded(fieldValue));
        if (oldValue != null) {
            throw new IllegalArgumentException("Field mapper tried to set already defined key '" + fieldName + "'.");
        }
    }

    private Object convertToNumberIfNeeded(Object value) {
        if (this.numbersAsString || !(value instanceof String)) {
            return value;
        }
        try {
            return new BigDecimal((String)value);
        }
        catch (NumberFormatException e) {
            return value;
        }
    }

    public void start() {
        if (this.originHost == null || this.originHost.trim().isEmpty()) {
            try {
                this.originHost = InetUtil.getLocalHostName();
            }
            catch (UnknownHostException e) {
                this.addWarn("Could not determine local hostname", e);
                this.originHost = "unknown";
            }
        }
        if (this.shortPatternLayout == null) {
            this.shortPatternLayout = this.buildPattern(DEFAULT_SHORT_PATTERN);
        }
        if (this.fullPatternLayout == null) {
            this.fullPatternLayout = this.buildPattern(DEFAULT_FULL_PATTERN);
        }
        this.addBuiltInFieldMappers();
        super.start();
    }

    private PatternLayout buildPattern(String pattern) {
        PatternLayout patternLayout = new PatternLayout();
        patternLayout.setContext(this.getContext());
        patternLayout.setPattern(pattern);
        patternLayout.start();
        return patternLayout;
    }

    private void addBuiltInFieldMappers() {
        this.builtInFieldMappers.add(new SimpleFieldMapper<String>(this.loggerNameKey, ILoggingEvent::getLoggerName));
        this.builtInFieldMappers.add(new SimpleFieldMapper<String>(this.threadNameKey, ILoggingEvent::getThreadName));
        if (this.includeLevelName) {
            this.builtInFieldMappers.add(new SimpleFieldMapper<String>(this.levelNameKey, event -> event.getLevel().toString()));
        }
        if (this.includeRawMessage) {
            this.builtInFieldMappers.add(new SimpleFieldMapper<String>("raw_message", ILoggingEvent::getMessage));
        }
        if (this.includeCallerData) {
            this.builtInFieldMappers.add(new CallerDataFieldMapper());
        }
        if (this.includeRootCauseData) {
            this.builtInFieldMappers.add(new RootExceptionDataFieldMapper());
        }
        if (this.includeMarker) {
            this.builtInFieldMappers.add(new MarkerFieldMapper("marker"));
        }
        if (this.includeMdcData) {
            this.builtInFieldMappers.add(new MdcDataFieldMapper());
        }
    }

    public byte[] headerBytes() {
        return null;
    }

    public byte[] encode(ILoggingEvent event) {
        HashMap<String, Object> additionalFields = new HashMap<String, Object>(this.staticFields);
        this.addFieldMapperData(event, additionalFields, this.builtInFieldMappers);
        this.addFieldMapperData(event, additionalFields, this.fieldMappers);
        GelfMessage gelfMessage = new GelfMessage(this.originHost, this.shortPatternLayout.doLayout(event), this.fullPatternLayout.doLayout(event), event.getTimeStamp(), LevelToSyslogSeverity.convert((ILoggingEvent)event), additionalFields);
        byte[] json = this.gelfMessageToJson(gelfMessage);
        if (this.appendNewline) {
            byte[] sep = System.lineSeparator().getBytes(StandardCharsets.UTF_8);
            ByteBuffer bb = ByteBuffer.allocate(json.length + sep.length);
            bb.put(json);
            for (byte b : sep) {
                bb.put(b);
            }
            bb.flip();
            return bb.array();
        }
        return json;
    }

    private void addFieldMapperData(ILoggingEvent event, Map<String, Object> additionalFields, List<GelfFieldMapper<?>> mappers) {
        for (GelfFieldMapper<?> fieldMapper : mappers) {
            try {
                fieldMapper.mapField(event, (key, value) -> {
                    try {
                        this.addField(additionalFields, (String)key, value);
                    }
                    catch (IllegalArgumentException e) {
                        this.addWarn("Could not add field " + key, e);
                    }
                });
            }
            catch (Exception e) {
                this.addError("Exception in field mapper", e);
            }
        }
    }

    protected byte[] gelfMessageToJson(GelfMessage gelfMessage) {
        return gelfMessage.toJSON();
    }

    public byte[] footerBytes() {
        return null;
    }
}

