/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf;

import de.siegmar.logbackgelf.AbstractGelfAppender;
import de.siegmar.logbackgelf.AddressResolver;
import de.siegmar.logbackgelf.TcpConnection;
import de.siegmar.logbackgelf.pool.SimpleObjectPool;
import javax.net.SocketFactory;

public class GelfTcpAppender
extends AbstractGelfAppender {
    private static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 5000;
    private static final int DEFAULT_RECONNECT_INTERVAL = 60;
    private static final int DEFAULT_MAX_RETRIES = 2;
    private static final int DEFAULT_RETRY_DELAY = 3000;
    private static final int DEFAULT_POOL_SIZE = 2;
    private static final int DEFAULT_POOL_MAX_WAIT_TIME = 5000;
    private static final int DEFAULT_POOL_MAX_IDLE_TIME = -1;
    private int connectTimeout = 15000;
    private int socketTimeout = 5000;
    private int reconnectInterval = 60;
    private int maxRetries = 2;
    private int retryDelay = 3000;
    private int poolSize = 2;
    private int poolMaxWaitTime = 5000;
    private int poolMaxIdleTime = -1;
    private SimpleObjectPool<TcpConnection> connectionPool;

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getReconnectInterval() {
        return this.reconnectInterval;
    }

    public void setReconnectInterval(int reconnectInterval) {
        this.reconnectInterval = reconnectInterval;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(int retryDelay) {
        this.retryDelay = retryDelay;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public long getPoolMaxWaitTime() {
        return this.poolMaxWaitTime;
    }

    public void setPoolMaxWaitTime(int poolMaxWaitTime) {
        this.poolMaxWaitTime = poolMaxWaitTime;
    }

    public int getPoolMaxIdleTime() {
        return this.poolMaxIdleTime;
    }

    public void setPoolMaxIdleTime(int poolMaxIdleTime) {
        this.poolMaxIdleTime = poolMaxIdleTime;
    }

    @Override
    protected void startAppender() {
        AddressResolver addressResolver = new AddressResolver(this.getGraylogHost());
        this.connectionPool = new SimpleObjectPool<TcpConnection>(() -> new TcpConnection(this.initSocketFactory(), addressResolver, this.getGraylogPort(), this.connectTimeout, this.socketTimeout), this.poolSize, this.poolMaxWaitTime, this.reconnectInterval, this.poolMaxIdleTime);
    }

    protected SocketFactory initSocketFactory() {
        return SocketFactory.getDefault();
    }

    @Override
    protected void appendMessage(byte[] messageToSend) {
        int openRetries = this.maxRetries;
        while (!this.sendMessage(messageToSend)) {
            if (this.retryDelay > 0 && openRetries > 0) {
                try {
                    Thread.sleep(this.retryDelay);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            if (openRetries-- > 0 && this.isStarted()) continue;
        }
    }

    private boolean sendMessage(byte[] messageToSend) {
        try {
            this.connectionPool.execute(tcpConnection -> tcpConnection.write(messageToSend));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (Exception e) {
            this.addError(String.format("Error sending message via tcp://%s:%s", this.getGraylogHost(), this.getGraylogPort()), e);
            return false;
        }
        return true;
    }

    @Override
    protected void close() {
        this.connectionPool.close();
    }
}

