/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.logbackgelf.mappers;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import de.siegmar.logbackgelf.GelfFieldMapper;
import java.util.Optional;
import java.util.function.BiConsumer;

public class RootExceptionDataFieldMapper
implements GelfFieldMapper<Object> {
    @Override
    public void mapField(ILoggingEvent event, BiConsumer<String, Object> valueHandler) {
        Optional.ofNullable(this.getRootException(event.getThrowableProxy())).ifPresent(rootException -> {
            valueHandler.accept("root_cause_class_name", rootException.getClassName());
            valueHandler.accept("root_cause_message", rootException.getMessage());
        });
    }

    private IThrowableProxy getRootException(IThrowableProxy throwableProxy) {
        if (throwableProxy == null) {
            return null;
        }
        IThrowableProxy rootCause = throwableProxy;
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
        }
        return rootCause;
    }
}

