/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document;

import dev.langchain4j.internal.ValidationUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Metadata {
    private final Map<String, String> metadata;

    public Metadata() {
        this(new HashMap<String, String>());
    }

    public Metadata(Map<String, String> metadata) {
        this.metadata = ValidationUtils.ensureNotNull(metadata, "metadata");
    }

    public String get(String key) {
        return this.metadata.get(key);
    }

    public Metadata add(String key, Object value) {
        this.metadata.put(key, value.toString());
        return this;
    }

    public Metadata remove(String key) {
        this.metadata.remove(key);
        return this;
    }

    public Metadata copy() {
        return new Metadata(new HashMap<String, String>(this.metadata));
    }

    public Map<String, String> asMap() {
        return new HashMap<String, String>(this.metadata);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata that = (Metadata)o;
        return Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.metadata);
    }

    public String toString() {
        return "Metadata { metadata = " + this.metadata + " }";
    }

    public static Metadata from(String key, Object value) {
        return new Metadata().add(key, value);
    }

    public static Metadata from(Map<String, String> metadata) {
        return new Metadata(metadata);
    }

    public static Metadata metadata(String key, Object value) {
        return Metadata.from(key, value);
    }
}

