/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.message;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.internal.Utils;
import java.util.Objects;

public class UserMessage
extends ChatMessage {
    private final String name;

    public UserMessage(String text) {
        this(null, text);
    }

    public UserMessage(String name, String text) {
        super(text);
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    @Override
    public ChatMessageType type() {
        return ChatMessageType.USER;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserMessage that = (UserMessage)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.text, that.text);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.text);
    }

    public String toString() {
        return "UserMessage { name = " + Utils.quoted(this.name) + " text = " + Utils.quoted(this.text) + " }";
    }

    public static UserMessage from(String text) {
        return new UserMessage(text);
    }

    public static UserMessage from(String name, String text) {
        return new UserMessage(name, text);
    }

    public static UserMessage userMessage(String text) {
        return UserMessage.from(text);
    }

    public static UserMessage userMessage(String name, String text) {
        return UserMessage.from(name, text);
    }
}

