/*
 * Decompiled with CFR 0.152.
 */
package global.hh.openapi.sdk.utils;

import global.hh.openapi.sdk.config.Config;
import global.hh.openapi.sdk.exception.BaseException;
import global.hh.openapi.sdk.exception.BusinessException;
import global.hh.openapi.sdk.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class httpUtils {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String METHOD_POST = "POST";
    private static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    private static final int DEFAULT_READ_TIMEOUT = 60000;

    public static String doPost(Config config, String url, String body) throws BaseException {
        return httpUtils.doPost(config, url, body, 60000, 60000, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPost(Config config, String url, String body, int connectTimeout, int readTimeout, Map<String, String> headerMap) throws BaseException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        String result = null;
        try {
            httpUtils.setLogInfo(config, "request: " + body);
            conn = httpUtils.getConnection(new URL(url), METHOD_POST, headerMap);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = conn.getOutputStream();
            out.write(body.getBytes(DEFAULT_CHARSET));
            result = httpUtils.getResponseAsString(conn);
        }
        catch (Exception e) {
            try {
                httpUtils.setLogError(config, "\u8c03\u7528\u63a5\u53e3\u5f02\u5e38\uff0c url=" + url + ", result=" + result);
                e.printStackTrace();
                throw new BusinessException(e.getMessage());
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (conn == null) throw throwable;
                    conn.disconnect();
                    throw throwable;
                }
                catch (Exception e2) {
                    httpUtils.setLogError(config, "\u8c03\u7528\u63a5\u53e3\u5173\u95ed\u8fde\u63a5\u5f02\u5e38\uff0c url=" + url + ", result=" + result);
                }
                throw throwable;
            }
        }
        try {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        catch (Exception e) {
            httpUtils.setLogError(config, "\u8c03\u7528\u63a5\u53e3\u5173\u95ed\u8fde\u63a5\u5f02\u5e38\uff0c url=" + url + ", result=" + result);
        }
        httpUtils.setLogInfo(config, "response: " + result);
        return result;
    }

    private static HttpURLConnection getConnection(URL url, String method, Map<String, String> headerMap) throws IOException {
        HttpURLConnection conn;
        if ("https".equals(url.getProtocol())) {
            SSLContext ctx;
            try {
                ctx = SSLContext.getInstance("TLS");
                ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            HttpsURLConnection connHttps = (HttpsURLConnection)url.openConnection();
            connHttps.setSSLSocketFactory(ctx.getSocketFactory());
            connHttps.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            conn = connHttps;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "*/*");
        conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        conn.setRequestProperty("Accept-Encoding", "gzip");
        if (headerMap != null) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return conn;
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = httpUtils.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return httpUtils.getStreamAsString(conn.getInputStream(), charset, conn);
        }
        String msg = httpUtils.getStreamAsString(es, charset, conn);
        if (StringUtils.isEmpty(msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset, HttpURLConnection conn) throws IOException {
        try {
            InputStreamReader reader = "gzip".equals(conn.getContentEncoding()) ? new InputStreamReader((InputStream)new GZIPInputStream(stream), charset) : new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (!StringUtils.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    private static void setLogInfo(Config config, String message) {
        if (config.getBiostimeSdkLogger() != null) {
            config.getBiostimeSdkLogger().info(message);
        }
    }

    private static void setLogError(Config config, String message) {
        if (config.getBiostimeSdkLogger() != null) {
            config.getBiostimeSdkLogger().error(message);
        }
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

