/*
 * Decompiled with CFR 0.152.
 */
package icu.mhb.mybatisplus.plugln.core;

import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.ISqlSegment;
import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.query.Query;
import com.baomidou.mybatisplus.core.conditions.segments.AbstractISegmentList;
import com.baomidou.mybatisplus.core.conditions.segments.GroupBySegmentList;
import com.baomidou.mybatisplus.core.conditions.segments.HavingSegmentList;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.conditions.segments.OrderBySegmentList;
import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import icu.mhb.mybatisplus.plugln.base.mapper.JoinBaseMapper;
import icu.mhb.mybatisplus.plugln.core.JoinWrapper;
import icu.mhb.mybatisplus.plugln.core.func.JoinMethodFunc;
import icu.mhb.mybatisplus.plugln.core.func.JoinQueryFunc;
import icu.mhb.mybatisplus.plugln.core.support.SupportJoinLambdaWrapper;
import icu.mhb.mybatisplus.plugln.entity.FieldMapping;
import icu.mhb.mybatisplus.plugln.entity.HavingBuild;
import icu.mhb.mybatisplus.plugln.entity.ManyToManySelectBuild;
import icu.mhb.mybatisplus.plugln.entity.OneToOneSelectBuild;
import icu.mhb.mybatisplus.plugln.entity.OrderByBuild;
import icu.mhb.mybatisplus.plugln.entity.TableInfoExt;
import icu.mhb.mybatisplus.plugln.keyword.DefaultFuncKeyWord;
import icu.mhb.mybatisplus.plugln.keyword.IFuncKeyWord;
import icu.mhb.mybatisplus.plugln.tookit.IdUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionUtils;

public class JoinLambdaWrapper<T>
extends SupportJoinLambdaWrapper<T, JoinLambdaWrapper<T>>
implements Query<JoinLambdaWrapper<T>, T, SFunction<T, ?>>,
JoinMethodFunc<T>,
JoinQueryFunc<T, JoinLambdaWrapper<T>> {
    private String masterTableAlias;
    private IFuncKeyWord funcKeyWord;
    private boolean masterLogicDelete = true;
    private List<SharedString> joinSqlSelect = new ArrayList<SharedString>();
    private List<SharedString> joinSql = new ArrayList<SharedString>();
    private List<String> joinConditionSql = new ArrayList<String>();
    private List<OneToOneSelectBuild> oneToOneSelectBuildList = null;
    private List<ManyToManySelectBuild> manyToManySelectBuildList = null;
    private boolean sqlCacheFlag;
    private SharedString sqlCache = new SharedString();
    private boolean sqlSelectFlag;
    private SharedString sqlSelectCahce = new SharedString();
    private boolean notDefaultSelectAll = false;
    private boolean hasDistinct = false;

    public JoinLambdaWrapper(T entity, String alias) {
        super.setEntity(entity);
        this.initNeed();
        if (StringUtils.isNotBlank((CharSequence)alias)) {
            this.setAlias(alias);
        }
        this.masterTableAlias = this.getAlias();
    }

    public JoinLambdaWrapper(T entity) {
        this(entity, null);
    }

    public JoinLambdaWrapper(Class<T> entityClass, String alias) {
        super.setEntityClass(entityClass);
        this.initNeed();
        if (StringUtils.isNotBlank((CharSequence)alias)) {
            this.setAlias(alias);
        }
        this.masterTableAlias = this.getAlias();
    }

    public JoinLambdaWrapper(Class<T> entityClass) {
        this(entityClass, (String)null);
    }

    JoinLambdaWrapper(T entity, Class<T> entityClass, SharedString sqlSelect, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments, Map<Class<?>, String> aliasMap, SharedString lastSql, SharedString sqlComment, SharedString sqlFirst) {
        super.setEntity(entity);
        super.setEntityClass(entityClass);
        this.paramNameSeq = paramNameSeq;
        this.aliasMap = aliasMap;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
        this.sqlSelect = sqlSelect;
        this.lastSql = lastSql;
        this.sqlComment = sqlComment;
        this.sqlFirst = sqlFirst;
    }

    public JoinLambdaWrapper<T> masterLogicDelete(boolean masterLogicDelete) {
        this.masterLogicDelete = masterLogicDelete;
        return (JoinLambdaWrapper)this.typedThis;
    }

    @SafeVarargs
    public final JoinLambdaWrapper<T> select(SFunction<T, ?> ... columns) {
        if (ArrayUtils.isNotEmpty((Object[])columns)) {
            this.sqlSelect.setStringValue(this.columnsToString(false, true, columns));
        }
        return (JoinLambdaWrapper)this.typedThis;
    }

    public JoinLambdaWrapper<T> distinct() {
        this.hasDistinct = true;
        return (JoinLambdaWrapper)this.typedThis;
    }

    public JoinLambdaWrapper<T> select(Class<T> entityClass, Predicate<TableFieldInfo> predicate) {
        super.setEntityClass(entityClass);
        this.sqlSelect.setStringValue(new TableInfoExt(TableInfoHelper.getTableInfo(this.getEntityOrMasterClass())).chooseSelect(predicate, this.getAlias()));
        return (JoinLambdaWrapper)this.typedThis;
    }

    public String getSqlSelect() {
        if (this.sqlSelectFlag) {
            return this.sqlSelectCahce.getStringValue();
        }
        if (StringUtils.isBlank((CharSequence)this.sqlSelect.getStringValue()) && !this.notDefaultSelectAll) {
            this.selectAll();
        }
        StringBuilder stringValue = new StringBuilder(this.sqlSelect.getStringValue());
        String joinSelectSql = this.joinSqlSelect.stream().map(SharedString::getStringValue).filter(StringUtils::isNotBlank).collect(Collectors.joining(","));
        if (stringValue.length() > 0 && StringUtils.isNotBlank((CharSequence)joinSelectSql)) {
            stringValue.append(",");
        }
        stringValue.append(joinSelectSql);
        if (CollectionUtils.isNotEmpty((Collection)this.sunQueryList)) {
            if (stringValue.length() > 0) {
                stringValue.append(",");
            }
            this.sunQueryList.stream().map(SharedString::getStringValue).forEach(stringValue::append);
        }
        String selectSql = stringValue.toString();
        this.sqlSelectFlag = true;
        if (this.hasDistinct) {
            selectSql = this.getFuncKeyWord().distinct() + " " + selectSql;
        }
        this.sqlSelectCahce.setStringValue(selectSql);
        return selectSql;
    }

    public JoinLambdaWrapper<T> notDefaultSelectAll() {
        this.notDefaultSelectAll = true;
        return (JoinLambdaWrapper)this.typedThis;
    }

    public JoinLambdaWrapper<T> changeQueryWrapper(AbstractWrapper queryWrapper) {
        MergeSegments mergeSegments = queryWrapper.getExpression();
        String id = IdUtil.getSimpleUUID();
        for (int i = 0; i < mergeSegments.getNormal().size(); ++i) {
            ISqlSegment iSqlSegment = (ISqlSegment)mergeSegments.getNormal().get(i);
            if (iSqlSegment instanceof SqlKeyword) continue;
            String sqlSegment = iSqlSegment.getSqlSegment();
            if (!sqlSegment.contains("#{")) {
                mergeSegments.getNormal().remove((Object)iSqlSegment);
                mergeSegments.getNormal().add(i, (ISqlSegment & Serializable)() -> this.getAliasAndField(sqlSegment));
                continue;
            }
            mergeSegments.getNormal().remove((Object)iSqlSegment);
            mergeSegments.getNormal().add(i, (ISqlSegment & Serializable)() -> sqlSegment.replaceAll("ew.paramNameValuePairs", "ew.paramNameValuePairs." + id));
        }
        this.expressionAdd((AbstractISegmentList)mergeSegments.getNormal(), null);
        GroupBySegmentList groupBy = mergeSegments.getGroupBy();
        for (int i = 0; i < groupBy.size(); ++i) {
            String sqlSegment;
            ISqlSegment iSqlSegment = (ISqlSegment)groupBy.get(i);
            if (iSqlSegment instanceof SqlKeyword || (sqlSegment = iSqlSegment.getSqlSegment()).contains("#{")) continue;
            mergeSegments.getGroupBy().remove((Object)iSqlSegment);
            mergeSegments.getGroupBy().add(i, (ISqlSegment & Serializable)() -> this.getAliasAndField(sqlSegment));
        }
        this.expressionAdd((AbstractISegmentList)mergeSegments.getGroupBy(), SqlKeyword.GROUP_BY);
        HavingSegmentList having = mergeSegments.getHaving();
        for (int i = 0; i < having.size(); ++i) {
            String sqlSegment;
            ISqlSegment iSqlSegment = (ISqlSegment)having.get(i);
            if (iSqlSegment instanceof SqlKeyword || !(sqlSegment = iSqlSegment.getSqlSegment()).contains("#{")) continue;
            mergeSegments.getHaving().remove((Object)iSqlSegment);
            mergeSegments.getHaving().add(i, (ISqlSegment & Serializable)() -> sqlSegment.replaceAll("ew.paramNameValuePairs", "ew.paramNameValuePairs." + id));
        }
        this.expressionAdd((AbstractISegmentList)mergeSegments.getHaving(), SqlKeyword.HAVING);
        OrderBySegmentList orderBy = mergeSegments.getOrderBy();
        for (int i = 0; i < orderBy.size(); ++i) {
            String sqlSegment;
            ISqlSegment iSqlSegment = (ISqlSegment)orderBy.get(i);
            if (iSqlSegment instanceof SqlKeyword || (sqlSegment = iSqlSegment.getSqlSegment()).contains("#{")) continue;
            mergeSegments.getOrderBy().remove((Object)iSqlSegment);
            mergeSegments.getOrderBy().add(i, (ISqlSegment & Serializable)() -> this.getAliasAndField(sqlSegment));
        }
        this.expressionAdd((AbstractISegmentList)mergeSegments.getOrderBy(), SqlKeyword.ORDER_BY);
        this.getParamNameValuePairs().put(id, queryWrapper.getParamNameValuePairs());
        return (JoinLambdaWrapper)this.typedThis;
    }

    private void expressionAdd(AbstractISegmentList list, SqlKeyword sqlKeyword) {
        if (!list.isEmpty()) {
            if (null != sqlKeyword) {
                list.add(0, (Object)sqlKeyword);
            }
            ISqlSegment[] iSqlSegmentArrays = new ISqlSegment[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                ISqlSegment sqlSegment;
                iSqlSegmentArrays[i] = sqlSegment = (ISqlSegment)list.get(i);
            }
            this.getExpression().add(iSqlSegmentArrays);
        }
    }

    protected JoinLambdaWrapper<T> instance() {
        return new JoinLambdaWrapper<Object>(this.getEntity(), this.getEntityClass(), null, this.paramNameSeq, this.paramNameValuePairs, new MergeSegments(), this.getAliasMap(), SharedString.emptyString(), SharedString.emptyString(), SharedString.emptyString());
    }

    public void clear() {
        super.clear();
        this.sqlSelect.toEmpty();
        this.sqlSelectCahce.toEmpty();
        this.sqlSelectFlag = false;
        this.sqlCache.toEmpty();
        this.sqlCacheFlag = false;
        this.joinSql.clear();
        this.joinSqlSelect.clear();
        this.joinConditionSql.clear();
        this.aliasMap.clear();
        this.orderByBuildList.clear();
        this.fieldMappingList.clear();
    }

    public String getSqlSegment() {
        if (this.sqlCacheFlag) {
            return this.sqlCache.getStringValue();
        }
        if (this.orderByBuildList.size() > 0) {
            this.orderByBuildList = this.orderByBuildList.stream().sorted(Comparator.comparing(OrderByBuild::getIndex)).collect(Collectors.toList());
            this.orderByBuildList.forEach(i -> {
                if (i.isSql()) {
                    this.doIt(i.isCondition(), new ISqlSegment[]{SqlKeyword.ORDER_BY, i.getColumn()});
                } else {
                    this.doIt(i.isCondition(), new ISqlSegment[]{SqlKeyword.ORDER_BY, i.getColumn(), i.isAsc() ? SqlKeyword.ASC : SqlKeyword.DESC});
                }
            });
        }
        String sql = this.expression.getSqlSegment();
        StringBuilder sqlBuilder = new StringBuilder();
        boolean nonEmptyOfEntity = this.nonEmptyOfEntity();
        boolean sqlIsBlank = StringUtils.isBlank((CharSequence)sql) || this.expression.getNormal().size() == 0;
        boolean conditionSqlIsNotEmpty = CollectionUtils.isNotEmpty(this.joinConditionSql);
        TableInfo tableInfo = TableInfoHelper.getTableInfo((Class)this.getEntityClass());
        if (sqlIsBlank && !nonEmptyOfEntity && conditionSqlIsNotEmpty && !tableInfo.isLogicDelete()) {
            sqlBuilder.append("WHERE");
        } else if (sqlIsBlank && !nonEmptyOfEntity && conditionSqlIsNotEmpty && tableInfo.isLogicDelete()) {
            sqlBuilder.append("and");
        } else if (conditionSqlIsNotEmpty && nonEmptyOfEntity && sqlIsBlank) {
            sqlBuilder.append("and");
        }
        if (conditionSqlIsNotEmpty) {
            for (int i2 = 0; i2 < this.joinConditionSql.size(); ++i2) {
                String conditionSql = this.joinConditionSql.get(i2);
                sqlBuilder.append(" ");
                if (i2 > 0) {
                    sqlBuilder.append("and");
                }
                sqlBuilder.append(conditionSql);
            }
        }
        if (!sqlIsBlank) {
            if (conditionSqlIsNotEmpty) {
                sqlBuilder.append(" ").append("and").append(" ");
            }
            sqlBuilder.append(sql);
        }
        if (sqlIsBlank && (this.expression.getOrderBy().size() > 0 || this.expression.getGroupBy().size() > 0 || this.expression.getHaving().size() > 0)) {
            sqlBuilder.append("\n").append(sql);
        }
        sqlBuilder.append("\n").append(this.lastSql.getStringValue());
        String sqlBuilderStr = sqlBuilder.toString();
        this.sqlCache.setStringValue(sqlBuilderStr);
        this.sqlCacheFlag = true;
        return sqlBuilderStr;
    }

    @Override
    public <J> JoinWrapper<J, T> join(Class<J> clz, String alias, boolean logicDelete) {
        return new JoinWrapper(clz, this, alias, logicDelete);
    }

    void setJoinConditionSql(List<SharedString> sunQueryList, List<SharedString> joinSql, String sql, String key, Map<String, Object> joinParamNameValuePairs) {
        if (CollectionUtils.isNotEmpty(joinParamNameValuePairs)) {
            this.paramNameValuePairs.put(key, joinParamNameValuePairs);
        }
        if (StringUtils.isNotBlank((CharSequence)sql)) {
            sql = sql.replace("WHERE", " ");
            sql = sql.replaceAll("ew.paramNameValuePairs", "ew.paramNameValuePairs." + key);
            this.joinConditionSql.add(sql);
        }
        if (CollectionUtils.isNotEmpty(sunQueryList)) {
            sunQueryList.forEach(i -> i.setStringValue(i.getStringValue().replaceAll("ew.paramNameValuePairs", "ew.paramNameValuePairs." + key)));
            this.sunQueryList.addAll(sunQueryList);
        }
        if (CollectionUtils.isNotEmpty(joinSql)) {
            joinSql.forEach(i -> i.setStringValue(i.getStringValue().replaceAll("ew.paramNameValuePairs", "ew.paramNameValuePairs." + key)));
            this.joinSql.addAll(joinSql);
        }
    }

    void setJoinSql(List<SharedString> sql) {
        if (CollectionUtils.isNotEmpty(sql)) {
            this.joinSql.addAll(sql);
        }
    }

    void setOrderBy(OrderBySegmentList orderBy) {
        if (!orderBy.isEmpty()) {
            for (ISqlSegment iSqlSegment : orderBy) {
                this.doIt(true, new ISqlSegment[]{SqlKeyword.ORDER_BY, iSqlSegment});
            }
        }
    }

    void setGroupBy(GroupBySegmentList groupBy) {
        if (!groupBy.isEmpty()) {
            for (ISqlSegment iSqlSegment : groupBy) {
                this.doIt(true, new ISqlSegment[]{SqlKeyword.GROUP_BY, iSqlSegment});
            }
        }
    }

    void setHaving(List<HavingBuild> havingBuildList) {
        if (havingBuildList != null && !havingBuildList.isEmpty()) {
            for (HavingBuild havingBuild : havingBuildList) {
                this.having(havingBuild.isCondition(), havingBuild.getSql(), havingBuild.getParams());
            }
        }
    }

    void setJoinSelect(SharedString ... select) {
        this.joinSqlSelect.addAll(Arrays.asList(select));
    }

    void setAliasMap(Map<Class<?>, String> aliasCacheMap) {
        if (CollectionUtils.isNotEmpty(aliasCacheMap)) {
            aliasCacheMap.forEach((k, v) -> this.aliasMap.put(k, v));
        }
    }

    void setLastSql(SharedString last) {
        if (StringUtils.isNotBlank((CharSequence)last.getStringValue())) {
            this.lastSql = last;
        }
    }

    protected void setFieldMappingList(List<FieldMapping> fieldMappingList) {
        if (CollectionUtils.isNotEmpty(fieldMappingList)) {
            this.fieldMappingList.addAll(fieldMappingList);
        }
    }

    void setOderByBuildList(List<OrderByBuild> orderByBuildList) {
        if (CollectionUtils.isNotEmpty(orderByBuildList)) {
            this.orderByBuildList.addAll(orderByBuildList);
        }
    }

    void setSunQueryList(List<SharedString> sunQueryList) {
        if (CollectionUtils.isNotEmpty(sunQueryList)) {
            this.sunQueryList.addAll(sunQueryList);
        }
    }

    void setOneToOneSelect(OneToOneSelectBuild oneToOneSelect) {
        if (null == oneToOneSelect) {
            return;
        }
        if (null == this.oneToOneSelectBuildList) {
            this.oneToOneSelectBuildList = new ArrayList<OneToOneSelectBuild>();
        }
        this.oneToOneSelectBuildList.add(oneToOneSelect);
    }

    void setManyToManySelect(ManyToManySelectBuild manyToManySelect) {
        if (null == manyToManySelect) {
            return;
        }
        if (null == this.manyToManySelectBuildList) {
            this.manyToManySelectBuildList = new ArrayList<ManyToManySelectBuild>();
        }
        this.manyToManySelectBuildList.add(manyToManySelect);
    }

    public String getJoinSql() {
        StringBuilder sql = new StringBuilder();
        if (CollectionUtils.isNotEmpty(this.joinSql)) {
            for (SharedString sharedString : this.joinSql) {
                sql.append(sharedString.getStringValue()).append("\n");
            }
        }
        return sql.toString();
    }

    public String getCustomSqlSegment() {
        return super.getCustomSqlSegment();
    }

    @Override
    protected void initNeed() {
        super.initNeed();
        Class entityClass = this.getEntityClass();
    }

    public List<FieldMapping> getFieldMappingList() {
        return this.fieldMappingList;
    }

    public IFuncKeyWord getFuncKeyWord() {
        if (this.funcKeyWord == null) {
            this.funcKeyWord = new DefaultFuncKeyWord();
        }
        return this.funcKeyWord;
    }

    public JoinLambdaWrapper<T> setFuncKeyWord(IFuncKeyWord funcKeyWord) {
        this.funcKeyWord = funcKeyWord;
        return (JoinLambdaWrapper)this.typedThis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R executeQuery(SFunction<JoinBaseMapper<T>, R> function) {
        SqlSession sqlSession = SqlHelper.sqlSession(this.getEntityOrMasterClass());
        try {
            Object object = function.apply((Object)((JoinBaseMapper)JoinLambdaWrapper.getMapper(this.getEntityOrMasterClass(), sqlSession)));
            return (R)object;
        }
        finally {
            SqlSessionUtils.closeSqlSession((SqlSession)sqlSession, (SqlSessionFactory)GlobalConfigUtils.currentSessionFactory(this.getEntityOrMasterClass()));
        }
    }

    public static <T, M extends BaseMapper<T>> M getMapper(Class<T> entityClass, SqlSession sqlSession) {
        Assert.notNull(entityClass, (String)"entityClass can't be null!", (Object[])new Object[0]);
        TableInfo tableInfo = Optional.ofNullable(TableInfoHelper.getTableInfo(entityClass)).orElseThrow(() -> ExceptionUtils.mpe((String)"Can not find TableInfo from Class: \"%s\".", (Object[])new Object[]{entityClass.getName()}));
        Class mapperClass = ClassUtils.toClassConfident((String)tableInfo.getCurrentNamespace());
        return (M)((BaseMapper)SqlHelper.sqlSessionFactory(entityClass).getConfiguration().getMapper(mapperClass, sqlSession));
    }

    public String getMasterTableAlias() {
        return this.masterTableAlias;
    }

    public boolean isMasterLogicDelete() {
        return this.masterLogicDelete;
    }

    public List<OneToOneSelectBuild> getOneToOneSelectBuildList() {
        return this.oneToOneSelectBuildList;
    }

    public List<ManyToManySelectBuild> getManyToManySelectBuildList() {
        return this.manyToManySelectBuildList;
    }
}

