/*
 * Decompiled with CFR 0.152.
 */
package icu.mhb.mybatisplus.plugln.core;

import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.query.Query;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.core.toolkit.support.SerializedLambda;
import icu.mhb.mybatisplus.plugln.core.JoinLambdaWrapper;
import icu.mhb.mybatisplus.plugln.core.support.SupportJoinLambdaWrapper;
import icu.mhb.mybatisplus.plugln.entity.As;
import icu.mhb.mybatisplus.plugln.entity.ColumnsBuilder;
import icu.mhb.mybatisplus.plugln.entity.FieldMapping;
import icu.mhb.mybatisplus.plugln.entity.HavingBuild;
import icu.mhb.mybatisplus.plugln.entity.ManyToManySelectBuild;
import icu.mhb.mybatisplus.plugln.entity.OneToOneSelectBuild;
import icu.mhb.mybatisplus.plugln.entity.TableFieldInfoExt;
import icu.mhb.mybatisplus.plugln.entity.TableInfoExt;
import icu.mhb.mybatisplus.plugln.enums.SqlExcerpt;
import icu.mhb.mybatisplus.plugln.exception.Exceptions;
import icu.mhb.mybatisplus.plugln.extend.Joins;
import icu.mhb.mybatisplus.plugln.tookit.IdUtil;
import icu.mhb.mybatisplus.plugln.tookit.Lambdas;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.ibatis.reflection.property.PropertyNamer;

public class JoinWrapper<T, J>
extends SupportJoinLambdaWrapper<T, JoinWrapper<T, J>>
implements Query<JoinWrapper<T, J>, T, SFunction<T, ?>> {
    private JoinLambdaWrapper<J> wrapper;
    private List<SharedString> sqlJoin = new ArrayList<SharedString>();
    private List<HavingBuild> havingBuildList = null;
    private OneToOneSelectBuild oneToOneSelectBuild = null;
    private ManyToManySelectBuild manyToManySelectBuild = null;
    private boolean logicDeleteIsApplyJoin = true;

    JoinWrapper(JoinLambdaWrapper<J> wrapper) {
        this(null, wrapper);
    }

    JoinWrapper(T entity, JoinLambdaWrapper<J> wrapper) {
        this(entity, wrapper, null);
    }

    JoinWrapper(T entity, JoinLambdaWrapper<J> wrapper, String alias) {
        this(entity, wrapper, alias, true);
    }

    JoinWrapper(T entity, JoinLambdaWrapper<J> wrapper, String alias, boolean logicDelete) {
        super.setEntity(entity);
        super.initNeed();
        if (CollectionUtils.isNotEmpty(wrapper.getAliasMap())) {
            wrapper.getAliasMap().forEach((k, v) -> this.aliasMap.put(k, v));
        }
        if (StringUtils.isBlank((CharSequence)alias)) {
            this.aliasMap.remove(this.getEntityOrMasterClass());
        } else {
            this.aliasMap.put(this.getEntityOrMasterClass(), alias);
        }
        this.logicDeleteIsApplyJoin = logicDelete;
        this.wrapper = wrapper;
    }

    JoinWrapper(Class<T> entityClass, JoinLambdaWrapper<J> wrapper, String alias) {
        this(entityClass, wrapper, alias, true);
    }

    JoinWrapper(Class<T> entityClass, JoinLambdaWrapper<J> wrapper, String alias, boolean logicDelete) {
        super.setEntityClass(entityClass);
        super.initNeed();
        if (CollectionUtils.isNotEmpty(wrapper.getAliasMap())) {
            wrapper.getAliasMap().forEach((k, v) -> this.aliasMap.put(k, v));
        }
        if (StringUtils.isBlank((CharSequence)alias)) {
            this.aliasMap.remove(entityClass);
        } else {
            this.aliasMap.put(entityClass, alias);
        }
        this.logicDeleteIsApplyJoin = logicDelete;
        this.wrapper = wrapper;
    }

    JoinWrapper(Class<T> entityClass, JoinLambdaWrapper<J> wrapper, boolean logicDelete) {
        this(entityClass, wrapper, (String)null, logicDelete);
    }

    JoinWrapper(T entity, Class<T> entityClass, SharedString sqlSelect, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments, Map<Class<?>, String> aliasMap, SharedString lastSql, SharedString sqlComment, SharedString sqlFirst) {
        super.setEntity(entity);
        super.setEntityClass(entityClass);
        this.paramNameSeq = paramNameSeq;
        this.aliasMap = aliasMap;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
        this.sqlSelect = sqlSelect;
        this.lastSql = lastSql;
        this.sqlComment = sqlComment;
        this.sqlFirst = sqlFirst;
    }

    @SafeVarargs
    public final JoinWrapper<T, J> select(SFunction<T, ?> ... columns) {
        if (ArrayUtils.isNotEmpty((Object[])columns)) {
            this.sqlSelect.setStringValue(this.columnsToString(false, true, columns));
        }
        return (JoinWrapper)this.typedThis;
    }

    public <P> JoinWrapper<T, J> manyToManySelect(SFunction<P, ?> column, Class<?> manyToManyClass) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(manyToManyClass);
        Assert.notNull((Object)tableInfo, (String)"cat not get tableInfo from Class: \"%s\".", (Object[])new Object[]{manyToManyClass.getName()});
        return this.manyToManySelect(column, manyToManyClass, cb -> {
            tableInfo.getFieldList().stream().filter(TableFieldInfo::isSelect).forEach(fieldInfo -> cb.add(Lambdas.getSFunction(manyToManyClass, fieldInfo.getPropertyType(), fieldInfo.getProperty())));
            if (StringUtils.isNotBlank((CharSequence)tableInfo.getKeyColumn())) {
                cb.add(Lambdas.getSFunction(manyToManyClass, tableInfo.getKeyType(), tableInfo.getKeyProperty()));
            }
        });
    }

    public <P> JoinWrapper<T, J> manyToManySelect(SFunction<P, ?> column, Class<?> manyToManyClass, Consumer<ColumnsBuilder<T>> consumer) {
        List<FieldMapping> belongsColumns = this.buildField(column, consumer);
        SerializedLambda lambdaMeta = LambdaUtils.resolve(column);
        String fieldName = PropertyNamer.methodToProperty((String)lambdaMeta.getImplMethodName());
        this.manyToManySelectBuild = ManyToManySelectBuild.builder().manyToManyField(fieldName).manyToManyPropertyType(lambdaMeta.getInstantiatedType().getDeclaredField(fieldName).getType()).belongsColumns(belongsColumns).manyToManyClass(manyToManyClass).build();
        return (JoinWrapper)this.typedThis;
    }

    public <P> JoinWrapper<T, J> oneToOneSelect(SFunction<P, ?> column, Class<?> modelClass) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(modelClass);
        Assert.notNull((Object)tableInfo, (String)"cat not get tableInfo from Class: \"%s\".", (Object[])new Object[]{modelClass.getName()});
        return this.oneToOneSelect(column, (ColumnsBuilder<T> cb) -> {
            tableInfo.getFieldList().stream().filter(TableFieldInfo::isSelect).forEach(fieldInfo -> cb.add(Lambdas.getSFunction(modelClass, fieldInfo.getPropertyType(), fieldInfo.getProperty())));
            if (StringUtils.isNotBlank((CharSequence)tableInfo.getKeyColumn())) {
                cb.add(Lambdas.getSFunction(modelClass, tableInfo.getKeyType(), tableInfo.getKeyProperty()));
            }
        });
    }

    public <P> JoinWrapper<T, J> oneToOneSelect(SFunction<P, ?> column, Consumer<ColumnsBuilder<T>> consumer) {
        List<FieldMapping> belongsColumns = this.buildField(column, consumer);
        SerializedLambda lambdaMeta = LambdaUtils.resolve(column);
        String fieldName = PropertyNamer.methodToProperty((String)lambdaMeta.getImplMethodName());
        this.oneToOneSelectBuild = OneToOneSelectBuild.builder().oneToOneField(fieldName).belongsColumns(belongsColumns).oneToOneClass(lambdaMeta.getInstantiatedType().getDeclaredField(fieldName).getType()).build();
        return (JoinWrapper)this.typedThis;
    }

    private <P> List<FieldMapping> buildField(SFunction<P, ?> column, Consumer<ColumnsBuilder<T>> consumer) {
        ColumnsBuilder columnsBuilder = new ColumnsBuilder();
        columnsBuilder.setTableName(this.getAlias());
        consumer.accept(columnsBuilder);
        ArrayList<String> selectColumn = new ArrayList<String>();
        ArrayList<FieldMapping> belongsColumns = new ArrayList<FieldMapping>();
        for (As as : columnsBuilder.getColumnsBuilderList()) {
            String columnAlias;
            String columnNoAlias = "";
            if (as.getColumn() != null) {
                String columnToStringNoAlias;
                columnNoAlias = columnToStringNoAlias = this.columnToStringNoAlias(as.getColumn(), false);
                columnAlias = this.getAliasAndField(columnToStringNoAlias);
            } else {
                String string = columnAlias = as.isIfQuotes() ? StringUtils.quotaMark(column) : column.toString();
            }
            if (StringUtils.isNotBlank((CharSequence)as.getAlias())) {
                columnNoAlias = as.getAlias();
                columnAlias = String.format(SqlExcerpt.COLUMNS_AS.getSql(), columnAlias, as.getAlias());
            }
            if (null != as.getClassType()) {
                TableFieldInfo fieldInfo = this.getTableFieldInfoByFieldName(as.getFieldName(), as.getClassType());
                if (null != fieldInfo) {
                    TableFieldInfoExt fieldInfoExt = new TableFieldInfoExt(fieldInfo);
                    fieldInfoExt.setColumn(columnNoAlias);
                    fieldInfoExt.setProperty(as.getFieldName());
                    belongsColumns.add(new FieldMapping(columnNoAlias, as.getFieldName(), fieldInfoExt));
                } else {
                    belongsColumns.add(new FieldMapping(columnNoAlias, as.getFieldName(), null));
                }
            } else {
                belongsColumns.add(new FieldMapping(columnNoAlias, as.getFieldName(), null));
            }
            selectColumn.add(columnAlias);
        }
        this.selectAs(selectColumn);
        return belongsColumns;
    }

    public JoinWrapper<T, J> select(Class<T> entityClass, Predicate<TableFieldInfo> predicate) {
        super.setEntityClass(entityClass);
        this.sqlSelect.setStringValue(new TableInfoExt(TableInfoHelper.getTableInfo(this.getEntityOrMasterClass())).chooseSelect(predicate, this.getAlias()));
        return (JoinWrapper)this.typedThis;
    }

    public String getSqlSelect() {
        return this.sqlSelect.getStringValue();
    }

    protected JoinWrapper<T, J> instance() {
        return new JoinWrapper<Object, J>(this.getEntity(), this.getEntityClass(), null, this.paramNameSeq, this.paramNameValuePairs, new MergeSegments(), this.aliasMap, SharedString.emptyString(), SharedString.emptyString(), SharedString.emptyString());
    }

    public void clear() {
        super.clear();
        this.wrapper = null;
        this.aliasMap.clear();
        this.oneToOneSelectBuild = null;
        this.manyToManySelectBuild = null;
        this.sqlJoin.clear();
        this.sqlSelect.toNull();
    }

    public <F> JoinWrapper<T, J> leftJoin(SFunction<T, Object> joinTableField, SFunction<F, Object> masterTableField) {
        this.buildJoinSql(joinTableField, masterTableField, SqlExcerpt.LEFT_JOIN);
        return (JoinWrapper)this.typedThis;
    }

    public <F> JoinWrapper<T, J> rightJoin(SFunction<T, Object> joinTableField, SFunction<F, Object> masterTableField) {
        this.buildJoinSql(joinTableField, masterTableField, SqlExcerpt.RIGHT_JOIN);
        return (JoinWrapper)this.typedThis;
    }

    public <F> JoinWrapper<T, J> innerJoin(SFunction<T, Object> joinTableField, SFunction<F, Object> masterTableField) {
        this.buildJoinSql(joinTableField, masterTableField, SqlExcerpt.INNER_JOIN);
        return (JoinWrapper)this.typedThis;
    }

    public JoinWrapper<T, J> having(boolean condition, String sqlHaving, Object ... params) {
        if (this.havingBuildList == null) {
            this.havingBuildList = new ArrayList<HavingBuild>();
        }
        HavingBuild havingBuild = HavingBuild.builder().condition(condition).sql(sqlHaving).params(params).build();
        this.havingBuildList.add(havingBuild);
        return (JoinWrapper)this.typedThis;
    }

    public JoinWrapper<T, J> joinAnd(SFunction<T, Object> field, Object val, int index) {
        String column = this.columnToString(field);
        SharedString sql = this.sqlJoin.get(index);
        if (sql == null || StringUtils.isBlank((CharSequence)sql.getStringValue())) {
            throw Exceptions.mpje("no such subscript join", new Object[0]);
        }
        sql.setStringValue(sql.getStringValue() + String.format(SqlExcerpt.AND.getSql(), column, StringUtils.quotaMark((Object)val)));
        this.sqlJoin.remove(index);
        this.sqlJoin.add(index, sql);
        return (JoinWrapper)this.typedThis;
    }

    public <X> JoinWrapper<T, J> joinAnd(SFunction<T, Object> field, SFunction<X, Object> val, int index) {
        String column = this.columnToString(field);
        String valColumn = this.columnToString(val, true, false);
        SharedString sql = this.sqlJoin.get(index);
        if (sql == null || StringUtils.isBlank((CharSequence)sql.getStringValue())) {
            throw Exceptions.mpje("no such subscript join", new Object[0]);
        }
        sql.setStringValue(sql.getStringValue() + String.format(SqlExcerpt.AND.getSql(), column, valColumn));
        this.sqlJoin.remove(index);
        this.sqlJoin.add(index, sql);
        return (JoinWrapper)this.typedThis;
    }

    public <X> JoinWrapper<T, J> joinAnd(int index, Consumer<JoinWrapper<T, J>> consumer) {
        SharedString sql = this.sqlJoin.get(index);
        if (sql == null || StringUtils.isBlank((CharSequence)sql.getStringValue())) {
            throw Exceptions.mpje("no such subscript join", new Object[0]);
        }
        JoinWrapper joinWrapper = new JoinWrapper(Joins.of(this.getEntityOrMasterClass()));
        joinWrapper.aliasMap.putAll(this.getAliasMap());
        consumer.accept(joinWrapper);
        String condition = joinWrapper.getCustomSqlSegment();
        String key = IdUtil.getSimpleUUID();
        if (CollectionUtils.isNotEmpty((Map)joinWrapper.getParamNameValuePairs())) {
            this.paramNameValuePairs.put(key, joinWrapper.getParamNameValuePairs());
        }
        condition = condition.replaceAll("ew.paramNameValuePairs", "ew.paramNameValuePairs." + key);
        condition = condition.replaceFirst("WHERE", " ");
        sql.setStringValue(sql.getStringValue() + " " + "and" + condition);
        this.sqlJoin.remove(index);
        this.sqlJoin.add(index, sql);
        return (JoinWrapper)this.typedThis;
    }

    private <F> void buildJoinSql(SFunction<T, Object> joinTableField, SFunction<F, Object> masterTableField, SqlExcerpt sqlExcerpt) {
        SerializedLambda joinTableResolve = LambdaUtils.resolve(joinTableField);
        SerializedLambda masterTableResolve = LambdaUtils.resolve(masterTableField);
        Class joinTableClass = joinTableResolve.getInstantiatedType();
        Class masterTableClass = masterTableResolve.getInstantiatedType();
        TableInfo joinTableInfo = TableInfoHelper.getTableInfo((Class)joinTableClass);
        Assert.notNull((Object)joinTableInfo, (String)"can not find tableInfo cache for this entity [%s]", (Object[])new Object[]{joinTableClass.getName()});
        String joinTableAlias = this.getAlias(joinTableClass);
        String masterTableAlias = this.getAlias(masterTableClass);
        String joinColumn = this.getColumn(joinTableResolve, true, false);
        String masterColumn = this.getColumn(masterTableResolve, true, false);
        SharedString sharedString = SharedString.emptyString();
        sharedString.setStringValue(String.format(sqlExcerpt.getSql(), joinTableInfo.getTableName(), joinTableAlias, joinTableAlias, joinColumn, masterTableAlias, masterColumn));
        TableInfo tableInfo = TableInfoHelper.getTableInfo((Class)joinTableClass);
        if (null != tableInfo && this.logicDeleteIsApplyJoin) {
            TableInfoExt infoExt = new TableInfoExt(tableInfo);
            String logicDeleteSql = infoExt.getLogicDeleteSql(true, true, joinTableAlias);
            sharedString.setStringValue(sharedString.getStringValue() + " " + "\n" + logicDeleteSql);
        }
        this.sqlJoin.add(sharedString);
    }

    public JoinLambdaWrapper<J> end() {
        this.wrapper.setJoinSelect(this.sqlSelect);
        this.wrapper.setAliasMap(this.aliasMap);
        this.wrapper.setOderByBuildList(this.orderByBuildList);
        this.wrapper.setFieldMappingList(this.fieldMappingList);
        this.wrapper.setOrderBy(this.expression.getOrderBy());
        this.wrapper.setGroupBy(this.expression.getGroupBy());
        this.wrapper.setHaving(this.havingBuildList);
        this.wrapper.setLastSql(this.lastSql);
        this.wrapper.setOneToOneSelect(this.oneToOneSelectBuild);
        this.wrapper.setManyToManySelect(this.manyToManySelectBuild);
        this.lastSql.toEmpty();
        this.expression.getOrderBy().clear();
        this.expression.getHaving().clear();
        this.expression.getGroupBy().clear();
        this.wrapper.setJoinConditionSql(this.sunQueryList, this.sqlJoin, this.getCustomSqlSegment(), IdUtil.getSimpleUUID(), this.paramNameValuePairs);
        return this.wrapper;
    }
}

