/*
 * Decompiled with CFR 0.152.
 */
package icu.mhb.mybatisplus.plugln.entity;

import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import icu.mhb.mybatisplus.plugln.entity.As;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ColumnsBuilder<T> {
    private List<As<T>> columnsBuilderList = new ArrayList<As<T>>();
    private String tableName;

    public ColumnsBuilder<T> add(Collection<SFunction<T, ?>> columns) {
        if (CollectionUtils.isEmpty(columns)) {
            return this;
        }
        for (SFunction<T, ?> column : columns) {
            this.columnsBuilderList.add(new As<T>(this.tableName, column));
        }
        return this;
    }

    @SafeVarargs
    public final ColumnsBuilder<T> add(SFunction<T, ?> ... columns) {
        if (ArrayUtils.isEmpty((Object[])columns)) {
            return this;
        }
        return this.add(Arrays.asList(columns));
    }

    public ColumnsBuilder<T> add(SFunction<T, ?> column) {
        if (column == null) {
            return this;
        }
        return this.add(Collections.singletonList(column));
    }

    public <J> ColumnsBuilder<T> addFunAlias(SFunction<T, ?> column, SFunction<J, ?> alias) {
        if (column == null) {
            return this;
        }
        this.columnsBuilderList.add(new As<T>(column, alias));
        return this;
    }

    public ColumnsBuilder<T> add(SFunction<T, ?> column, String alias) {
        this.columnsBuilderList.add(new As<T>(column, alias));
        return this;
    }

    public ColumnsBuilder<T> add(Object columnStr, String alias) {
        this.columnsBuilderList.add(new As(columnStr, alias));
        return this;
    }

    public ColumnsBuilder<T> add(Object columnStr, String alias, boolean isQuotes) {
        this.columnsBuilderList.add(new As(columnStr, alias, isQuotes));
        return this;
    }

    public <F> ColumnsBuilder<T> add(SFunction<T, ?> column, String alias, SFunction<F, ?> fieldName) {
        this.columnsBuilderList.add(new As<T>(column, alias, fieldName));
        return this;
    }

    public ColumnsBuilder<T> addAll(List<As<T>> columnsBuilderList) {
        if (CollectionUtils.isNotEmpty(columnsBuilderList)) {
            this.columnsBuilderList.addAll(columnsBuilderList);
        }
        return this;
    }

    public List<As<T>> getColumnsBuilderList() {
        return this.columnsBuilderList;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

