/*
 * Decompiled with CFR 0.152.
 */
package icu.mhb.mybatisplus.plugln.entity;

import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlScriptUtils;
import icu.mhb.mybatisplus.plugln.entity.TableFieldInfoExt;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TableInfoExt {
    private TableInfo tableInfo;

    public TableInfoExt(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
    }

    public String chooseSelect(Predicate<TableFieldInfo> predicate, String alias) {
        String sqlSelect = StringUtils.isNotBlank((CharSequence)this.tableInfo.getKeyColumn()) ? TableFieldInfoExt.getAliasColumn(this.tableInfo.getKeySqlSelect(), alias) : "";
        String fieldsSqlSelect = this.tableInfo.getFieldList().stream().filter(predicate).map(TableFieldInfo::getSqlSelect).map(i -> TableFieldInfoExt.getAliasColumn(i, alias)).collect(Collectors.joining(","));
        if (StringUtils.isNotBlank((CharSequence)sqlSelect) && StringUtils.isNotBlank((CharSequence)fieldsSqlSelect)) {
            return sqlSelect + "," + fieldsSqlSelect;
        }
        if (StringUtils.isNotBlank((CharSequence)fieldsSqlSelect)) {
            return fieldsSqlSelect;
        }
        return sqlSelect;
    }

    public String getAllSqlWhere(boolean ignoreLogicDelFiled, boolean withId, String prefix) {
        String newPrefix = prefix == null ? "" : prefix;
        String filedSqlScript = this.tableInfo.getFieldList().stream().filter(i -> {
            if (ignoreLogicDelFiled) {
                return !this.tableInfo.isLogicDelete() || !i.isLogicDelete();
            }
            return true;
        }).map(TableFieldInfoExt::new).map(i -> i.getSqlWhere(newPrefix)).filter(Objects::nonNull).collect(Collectors.joining("\n"));
        if (!withId || StringUtils.isBlank((CharSequence)this.tableInfo.getKeyProperty())) {
            return filedSqlScript;
        }
        String newKeyProperty = newPrefix + this.tableInfo.getKeyProperty();
        String keySqlScript = TableFieldInfoExt.getAliasColumn(this.tableInfo.getKeyColumn(), null) + "=" + SqlScriptUtils.safeParam((String)newKeyProperty);
        return SqlScriptUtils.convertIf((String)keySqlScript, (String)String.format("%s != null", newKeyProperty), (boolean)false) + "\n" + filedSqlScript;
    }

    public String getLogicDeleteSql(boolean startWithAnd, boolean isWhere, String alias) {
        if (this.tableInfo.isLogicDelete()) {
            TableFieldInfo field = this.tableInfo.getFieldList().stream().filter(TableFieldInfo::isLogicDelete).findFirst().orElseThrow(() -> ExceptionUtils.mpe((String)"can't find the logicFiled from table {%s}", (Object[])new Object[]{this.tableInfo.getTableName()}));
            String logicDeleteSql = this.formatLogicDeleteSql(field, isWhere, alias);
            if (startWithAnd) {
                logicDeleteSql = " AND " + logicDeleteSql;
            }
            return logicDeleteSql;
        }
        return "";
    }

    public String getLogicDeleteSql(boolean startWithAnd, boolean isWhere) {
        return this.getLogicDeleteSql(startWithAnd, isWhere, null);
    }

    private String formatLogicDeleteSql(TableFieldInfo fieldInfo, boolean isWhere, String alias) {
        String value;
        String string = value = isWhere ? fieldInfo.getLogicNotDeleteValue() : fieldInfo.getLogicDeleteValue();
        if (isWhere) {
            if ("null".equalsIgnoreCase(value)) {
                return TableFieldInfoExt.getAliasColumn(fieldInfo.getColumn(), alias) + " IS NULL";
            }
            return TableFieldInfoExt.getAliasColumn(fieldInfo.getColumn(), alias) + "=" + String.format(fieldInfo.isCharSequence() ? "'%s'" : "%s", value);
        }
        String targetStr = TableFieldInfoExt.getAliasColumn(fieldInfo.getColumn(), alias) + "=";
        if ("null".equalsIgnoreCase(value)) {
            return targetStr + "null";
        }
        return targetStr + String.format(fieldInfo.isCharSequence() ? "'%s'" : "%s", value);
    }

    public TableInfo getTableInfo() {
        return this.tableInfo;
    }
}

