/*
 * Decompiled with CFR 0.152.
 */
package icu.mhb.mybatisplus.plugln.interceptor;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import icu.mhb.mybatisplus.plugln.config.MybatisPlusJoinConfig;
import icu.mhb.mybatisplus.plugln.core.JoinLambdaWrapper;
import icu.mhb.mybatisplus.plugln.entity.FieldMapping;
import icu.mhb.mybatisplus.plugln.entity.ManyToManySelectBuild;
import icu.mhb.mybatisplus.plugln.entity.OneToOneSelectBuild;
import icu.mhb.mybatisplus.plugln.enums.PropertyType;
import icu.mhb.mybatisplus.plugln.injector.JoinDefaultResultType;
import icu.mhb.mybatisplus.plugln.tookit.ClassUtils;
import icu.mhb.mybatisplus.plugln.tookit.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;

@Order(value=-2147483648)
@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class JoinInterceptor
implements Interceptor {
    @Autowired(required=false)
    private MybatisPlusJoinConfig mybatisPlusJoinConfig;
    private static final Map<String, Map<Configuration, MappedStatement>> MS_CACHE = new ConcurrentHashMap<String, Map<Configuration, MappedStatement>>();

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        if (args[0] instanceof MappedStatement) {
            MappedStatement ms = (MappedStatement)args[0];
            if (args[1] instanceof Map) {
                Object returnClass;
                Map map = (Map)args[1];
                Object ew = map.containsKey("ew") ? map.get("ew") : null;
                Object v0 = returnClass = map.containsKey("returnClassType0000000001111") ? map.get("returnClassType0000000001111") : null;
                if (ew instanceof JoinLambdaWrapper && returnClass != null) {
                    ResultMap resultMap;
                    JoinLambdaWrapper joinLambdaWrapper = ew;
                    Class classType = returnClass;
                    List list = ms.getResultMaps();
                    if (CollectionUtils.isNotEmpty((Collection)list) && (resultMap = (ResultMap)list.get(0)).getType() == JoinDefaultResultType.class) {
                        args[0] = this.newMappedStatement(ms, joinLambdaWrapper, classType);
                    }
                }
            }
        }
        return invocation.proceed();
    }

    private MappedStatement newMappedStatement(MappedStatement ms, JoinLambdaWrapper joinLambdaWrapper, Class<?> classType) {
        Map<Configuration, MappedStatement> statementMap;
        String id = ms.getId();
        if (this.getMybatisPlusJoinConfig().isUseMsCache()) {
            id = ms.getId() + ":" + classType.getName() + "_" + joinLambdaWrapper.getSqlSelect();
        }
        id.replaceAll(" ", "");
        Map<Configuration, MappedStatement> map = statementMap = !this.getMybatisPlusJoinConfig().isUseMsCache() ? null : MS_CACHE.get(id);
        if (CollectionUtils.isNotEmpty(statementMap) && Objects.nonNull(statementMap.get(ms.getConfiguration()))) {
            return statementMap.get(ms.getConfiguration());
        }
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), id, ms.getSqlSource(), ms.getSqlCommandType()).resource(ms.getResource()).fetchSize(ms.getFetchSize()).statementType(ms.getStatementType()).keyGenerator(ms.getKeyGenerator()).timeout(ms.getTimeout()).parameterMap(ms.getParameterMap()).resultSetType(ms.getResultSetType()).cache(ms.getCache()).flushCacheRequired(ms.isFlushCacheRequired()).useCache(ms.isUseCache());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            builder.keyProperty(String.join((CharSequence)",", ms.getKeyProperties()));
        }
        builder.resultMaps(Lists.newArrayList(this.newResultMap(ms, joinLambdaWrapper, classType)));
        MappedStatement mappedStatement = builder.build();
        if (statementMap == null) {
            statementMap = new ConcurrentHashMap<Configuration, MappedStatement>();
            if (this.getMybatisPlusJoinConfig().isUseMsCache()) {
                MS_CACHE.put(id, statementMap);
            }
        }
        statementMap.put(ms.getConfiguration(), mappedStatement);
        return mappedStatement;
    }

    private ResultMap newResultMap(MappedStatement ms, JoinLambdaWrapper<?> joinLambdaWrapper, Class<?> classType) {
        List<ManyToManySelectBuild> manyToManySelectBuildList;
        Configuration configuration = ms.getConfiguration();
        String id = ms.getId() + ":" + classType.getName() + "_" + joinLambdaWrapper.getSqlSelect();
        id = id.replaceAll(" ", "");
        if (PropertyType.hasBaseType(classType) || ClassUtils.hasIncludeClass(classType, Map.class)) {
            return new ResultMap.Builder(configuration, id, classType, Lists.newArrayList(0)).build();
        }
        if (configuration.hasResultMap(id)) {
            return configuration.getResultMap(id);
        }
        List<ResultMapping> resultMappings = this.buildResultMapping(configuration, joinLambdaWrapper.getFieldMappingList(), classType);
        List<OneToOneSelectBuild> oneToOneSelectBuildList = joinLambdaWrapper.getOneToOneSelectBuildList();
        if (CollectionUtils.isNotEmpty(oneToOneSelectBuildList)) {
            for (OneToOneSelectBuild oneToOneSelectBuild : oneToOneSelectBuildList) {
                String oneToOneId = id + "_" + oneToOneSelectBuild.getOneToOneField();
                if (!configuration.hasResultMap(oneToOneId = oneToOneId.replaceAll(" ", ""))) {
                    ResultMap oneToOneResultMap = new ResultMap.Builder(configuration, oneToOneId, oneToOneSelectBuild.getOneToOneClass(), this.buildResultMapping(configuration, oneToOneSelectBuild.getBelongsColumns(), oneToOneSelectBuild.getOneToOneClass())).build();
                    configuration.addResultMap(oneToOneResultMap);
                }
                resultMappings.add(new ResultMapping.Builder(configuration, oneToOneSelectBuild.getOneToOneField()).javaType(oneToOneSelectBuild.getOneToOneClass()).nestedResultMapId(oneToOneId).build());
            }
        }
        if (CollectionUtils.isNotEmpty(manyToManySelectBuildList = joinLambdaWrapper.getManyToManySelectBuildList())) {
            for (ManyToManySelectBuild manyToManySelectBuild : manyToManySelectBuildList) {
                String manyToManyId = id + "_" + manyToManySelectBuild.getManyToManyField();
                if (!configuration.hasResultMap(manyToManyId = manyToManyId.replaceAll(" ", ""))) {
                    ResultMap oneToOneResultMap = new ResultMap.Builder(configuration, manyToManyId, manyToManySelectBuild.getManyToManyClass(), this.buildResultMapping(configuration, manyToManySelectBuild.getBelongsColumns(), manyToManySelectBuild.getManyToManyClass())).build();
                    configuration.addResultMap(oneToOneResultMap);
                }
                resultMappings.add(new ResultMapping.Builder(configuration, manyToManySelectBuild.getManyToManyField()).javaType(manyToManySelectBuild.getManyToManyPropertyType()).nestedResultMapId(manyToManyId).build());
            }
        }
        ResultMap resultMap = new ResultMap.Builder(configuration, id, classType, resultMappings).build();
        configuration.addResultMap(resultMap);
        return resultMap;
    }

    private List<ResultMapping> buildResultMapping(Configuration configuration, List<FieldMapping> fieldMappings, Class<?> clz) {
        return fieldMappings.stream().map(fieldMapping -> {
            if (null != fieldMapping.getTableFieldInfoExt()) {
                return fieldMapping.getTableFieldInfoExt().getResultMapping(configuration);
            }
            Class<?> propertyType = ClassUtils.getDeclaredField(clz, fieldMapping.getFieldName()).getType();
            ResultMapping.Builder builder = new ResultMapping.Builder(configuration, fieldMapping.getFieldName(), fieldMapping.getColumn(), propertyType);
            return builder.build();
        }).collect(Collectors.toList());
    }

    public MybatisPlusJoinConfig getMybatisPlusJoinConfig() {
        if (this.mybatisPlusJoinConfig == null) {
            this.mybatisPlusJoinConfig = MybatisPlusJoinConfig.builder().build();
        }
        return this.mybatisPlusJoinConfig;
    }
}

