/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages;

import io.cucumber.core.gherkin.messages.GherkinMessagesLocation;
import io.cucumber.core.gherkin.messages.GherkinMessagesScenario;
import io.cucumber.core.gherkin.messages.GherkinMessagesScenarioOutline;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.Scenario;
import io.cucumber.plugin.event.Location;
import io.cucumber.plugin.event.Node;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

final class GherkinMessagesRule
implements Node.Rule {
    private final Node parent;
    private final Rule rule;
    private final List<Node> children;

    GherkinMessagesRule(Node parent, Rule rule) {
        this.parent = parent;
        this.rule = rule;
        this.children = rule.getChildren().stream().filter(ruleChild -> ruleChild.getScenario() != null).map(ruleChild -> {
            Scenario scenario = ruleChild.getScenario();
            if (!scenario.getExamples().isEmpty()) {
                return new GherkinMessagesScenarioOutline((Node)this, scenario);
            }
            return new GherkinMessagesScenario((Node)this, scenario);
        }).collect(Collectors.toList());
    }

    public Optional<Node> getParent() {
        return Optional.of(this.parent);
    }

    public Collection<Node> elements() {
        return this.children;
    }

    public Location getLocation() {
        return GherkinMessagesLocation.from(this.rule.getLocation());
    }

    public Optional<String> getKeyword() {
        return Optional.of(this.rule.getKeyword());
    }

    public Optional<String> getName() {
        String name = this.rule.getName();
        return name.isEmpty() ? Optional.empty() : Optional.of(name);
    }
}

