/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWatchManager<T>
implements Watch {
    private static final Logger logger = LoggerFactory.getLogger(AbstractWatchManager.class);
    final Watcher<T> watcher;
    final AtomicReference<String> resourceVersion;
    final AtomicBoolean forceClosed;
    private final int reconnectLimit;
    private final int reconnectInterval;
    private final int maxIntervalExponent;
    final AtomicInteger currentReconnectAttempt;
    private final ScheduledExecutorService executorService;
    private final RequestBuilder requestBuilder;
    protected ClientRunner runner;

    AbstractWatchManager(Watcher<T> watcher, ListOptions listOptions, int reconnectLimit, int reconnectInterval, int maxIntervalExponent, RequestBuilder requestBuilder) {
        this.watcher = watcher;
        this.reconnectLimit = reconnectLimit;
        this.reconnectInterval = reconnectInterval;
        this.maxIntervalExponent = maxIntervalExponent;
        this.resourceVersion = new AtomicReference<String>(listOptions.getResourceVersion());
        this.currentReconnectAttempt = new AtomicInteger(0);
        this.forceClosed = new AtomicBoolean();
        this.executorService = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread ret = new Thread(r, "Executor for Watch " + System.identityHashCode(this));
            ret.setDaemon(true);
            return ret;
        });
        this.requestBuilder = requestBuilder;
    }

    protected void initRunner(ClientRunner runner) {
        if (this.runner != null) {
            throw new IllegalStateException("ClientRunner has already been initialized");
        }
        this.runner = runner;
    }

    final void closeEvent(WatcherException cause) {
        if (this.forceClosed.getAndSet(true)) {
            logger.debug("Ignoring duplicate firing of onClose event");
            return;
        }
        this.watcher.onClose(cause);
    }

    final void closeEvent() {
        if (this.forceClosed.getAndSet(true)) {
            logger.debug("Ignoring duplicate firing of onClose event");
            return;
        }
        this.watcher.onClose();
    }

    final void closeExecutorService() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            logger.debug("Closing ExecutorService");
            try {
                this.executorService.shutdown();
                if (!this.executorService.awaitTermination(1L, TimeUnit.SECONDS)) {
                    logger.warn("Executor didn't terminate in time after shutdown in close(), killing it.");
                    this.executorService.shutdownNow();
                }
            }
            catch (Exception t) {
                throw KubernetesClientException.launderThrowable(t);
            }
        }
    }

    void submit(Runnable task) {
        if (!this.executorService.isShutdown()) {
            this.executorService.submit(task);
        }
    }

    void schedule(Runnable command, long delay, TimeUnit timeUnit) {
        if (!this.executorService.isShutdown()) {
            this.executorService.schedule(command, delay, timeUnit);
        }
    }

    final boolean cannotReconnect() {
        return this.currentReconnectAttempt.get() >= this.reconnectLimit && this.reconnectLimit >= 0;
    }

    final long nextReconnectInterval() {
        int exponentOfTwo = this.currentReconnectAttempt.getAndIncrement();
        if (exponentOfTwo > this.maxIntervalExponent) {
            exponentOfTwo = this.maxIntervalExponent;
        }
        long ret = (long)this.reconnectInterval * (long)(1 << exponentOfTwo);
        logger.debug("Current reconnect backoff is {} milliseconds (T{})", (Object)ret, (Object)exponentOfTwo);
        return ret;
    }

    void resetReconnectAttempts() {
        this.currentReconnectAttempt.set(0);
    }

    boolean isForceClosed() {
        return this.forceClosed.get();
    }

    void eventReceived(Watcher.Action action, T resource) {
        this.watcher.eventReceived(action, resource);
    }

    void onClose(WatcherException cause) {
        this.watcher.onClose(cause);
    }

    void updateResourceVersion(String newResourceVersion) {
        this.resourceVersion.set(newResourceVersion);
    }

    protected void runWatch() {
        Request request = this.requestBuilder.build(this.resourceVersion.get());
        logger.debug("Watching {}...", (Object)request.url());
        this.runner.run(request);
    }

    public void waitUntilReady() {
        this.runner.waitUntilReady();
    }

    static void closeWebSocket(WebSocket webSocket) {
        if (webSocket != null) {
            logger.debug("Closing websocket {}", (Object)webSocket);
            try {
                if (!webSocket.close(1000, null)) {
                    logger.warn("Failed to close websocket");
                }
            }
            catch (IllegalStateException e) {
                logger.error("Called close on already closed websocket: {} {}", e.getClass(), (Object)e.getMessage());
            }
        }
    }

    @Override
    public void close() {
        logger.debug("Force closing the watch {}", (Object)this);
        this.closeEvent();
        this.runner.close();
        this.closeExecutorService();
    }

    static abstract class ClientRunner {
        private final OkHttpClient client;

        protected ClientRunner(OkHttpClient client) {
            this.client = this.cloneAndCustomize(client);
        }

        abstract void run(Request var1);

        void close() {
        }

        void waitUntilReady() {
        }

        abstract OkHttpClient cloneAndCustomize(OkHttpClient var1);

        OkHttpClient client() {
            return this.client;
        }
    }

    @FunctionalInterface
    static interface RequestBuilder {
        public Request build(String var1);
    }
}

