package io.fabric8.kubernetes.api.model.batch;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface JobStatusFluent<A extends JobStatusFluent<A>> extends Fluent<A> {


    public Integer getActive();
    public A withActive(Integer active);
    public Boolean hasActive();
    public A withNewActive(int arg1);
    public String getCompletionTime();
    public A withCompletionTime(String completionTime);
    public Boolean hasCompletionTime();
    public A withNewCompletionTime(StringBuilder arg1);
    public A withNewCompletionTime(int[] arg1,int arg2,int arg3);
    public A withNewCompletionTime(char[] arg1);
    public A withNewCompletionTime(StringBuffer arg1);
    public A withNewCompletionTime(byte[] arg1,int arg2);
    public A withNewCompletionTime(byte[] arg1);
    public A withNewCompletionTime(char[] arg1,int arg2,int arg3);
    public A withNewCompletionTime(byte[] arg1,int arg2,int arg3);
    public A withNewCompletionTime(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewCompletionTime(String arg1);
    public A addToConditions(int index,JobCondition item);
    public A setToConditions(int index,JobCondition item);
    public A addToConditions(JobCondition... items);
    public A addAllToConditions(Collection<JobCondition> items);
    public A removeFromConditions(JobCondition... items);
    public A removeAllFromConditions(Collection<JobCondition> items);
    public A removeMatchingFromConditions(Predicate<JobConditionBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<JobCondition> getConditions();
    public List<JobCondition> buildConditions();
    public JobCondition buildCondition(int index);
    public JobCondition buildFirstCondition();
    public JobCondition buildLastCondition();
    public JobCondition buildMatchingCondition(Predicate<JobConditionBuilder> predicate);
    public Boolean hasMatchingCondition(Predicate<JobConditionBuilder> predicate);
    public A withConditions(List<JobCondition> conditions);
    public A withConditions(JobCondition... conditions);
    public Boolean hasConditions();
    public JobStatusFluent.ConditionsNested<A> addNewCondition();
    public JobStatusFluent.ConditionsNested<A> addNewConditionLike(JobCondition item);
    public JobStatusFluent.ConditionsNested<A> setNewConditionLike(int index,JobCondition item);
    public JobStatusFluent.ConditionsNested<A> editCondition(int index);
    public JobStatusFluent.ConditionsNested<A> editFirstCondition();
    public JobStatusFluent.ConditionsNested<A> editLastCondition();
    public JobStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<JobConditionBuilder> predicate);
    public Integer getFailed();
    public A withFailed(Integer failed);
    public Boolean hasFailed();
    public A withNewFailed(int arg1);
    public String getStartTime();
    public A withStartTime(String startTime);
    public Boolean hasStartTime();
    public A withNewStartTime(StringBuilder arg1);
    public A withNewStartTime(int[] arg1,int arg2,int arg3);
    public A withNewStartTime(char[] arg1);
    public A withNewStartTime(StringBuffer arg1);
    public A withNewStartTime(byte[] arg1,int arg2);
    public A withNewStartTime(byte[] arg1);
    public A withNewStartTime(char[] arg1,int arg2,int arg3);
    public A withNewStartTime(byte[] arg1,int arg2,int arg3);
    public A withNewStartTime(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewStartTime(String arg1);
    public Integer getSucceeded();
    public A withSucceeded(Integer succeeded);
    public Boolean hasSucceeded();
    public A withNewSucceeded(int arg1);
    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,JobConditionFluent<JobStatusFluent.ConditionsNested<N>> {

            public N and();
            public N endCondition();    }


}
