/*
 * Decompiled with CFR 0.152.
 */
package com.gltqe.cipher;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gltqe.cipher.Cipher;
import com.gltqe.cipher.CipherHandle;
import java.io.IOException;
import java.lang.reflect.Field;

public class CipherDeserializer
extends JsonDeserializer<Object> {
    private static ObjectMapper mapper = new ObjectMapper();
    private CipherHandle cipherHandle;
    private Class<?> beanClass;

    public CipherDeserializer(CipherHandle cipherHandle) {
        this.cipherHandle = cipherHandle;
    }

    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode rootNode = (JsonNode)jsonParser.readValueAsTree();
        Object obj = null;
        try {
            obj = this.beanClass.newInstance();
            Field[] declaredFields = this.beanClass.getDeclaredFields();
            if (declaredFields.length > 0) {
                for (Field field : declaredFields) {
                    String fieldName = field.getName();
                    Cipher annotation = field.getAnnotation(Cipher.class);
                    field.setAccessible(true);
                    JsonNode node = rootNode.get(fieldName);
                    if (node == null) continue;
                    String fieldValue = node.asText();
                    if (annotation != null) {
                        Object value = this.cipherHandle.decryptHandle(annotation, fieldValue);
                        Class<?> type = field.getType();
                        if (String.class.equals(type)) {
                            field.set(obj, value);
                            continue;
                        }
                        Object o = mapper.readValue(String.valueOf(value), type);
                        field.set(obj, o);
                        continue;
                    }
                    field.set(obj, fieldValue);
                }
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return obj;
    }

    public CipherHandle getCipherHandle() {
        return this.cipherHandle;
    }

    public void setBeanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
    }
}

