/*
 * Decompiled with CFR 0.152.
 */
package com.gltqe.cipher;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.gltqe.cipher.Cipher;
import com.gltqe.cipher.CipherHandle;
import java.io.IOException;

public class CipherSerializer
extends JsonSerializer<Object> {
    private static ObjectMapper mapper = new ObjectMapper();
    private CipherHandle cipherHandle;
    private Cipher cipher;

    public CipherSerializer(CipherHandle cipherHandle) {
        this.cipherHandle = cipherHandle;
    }

    public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.cipher != null && o != null) {
            String json = mapper.writeValueAsString(o);
            Object value = this.cipherHandle.encryptHandle(this.cipher, json);
            jsonGenerator.writeObject(value);
        }
    }

    public void setCipher(Cipher cipher) {
        this.cipher = cipher;
    }

    public CipherHandle getCipherHandle() {
        return this.cipherHandle;
    }
}

