/*
 * Decompiled with CFR 0.152.
 */
package com.gltqe.dict;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.gltqe.dict.Dict;
import com.gltqe.dict.DictHandle;
import java.io.IOException;

public class DictSerializer
extends JsonSerializer<Object> {
    private Dict dict;
    private DictHandle dictHandle;

    public DictSerializer(DictHandle dictHandle) {
        this.dictHandle = dictHandle;
    }

    public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.dict != null && o != null) {
            jsonGenerator.writeObject(o);
            Object content = this.getDictContent(this.dict, String.valueOf(o));
            String fieldName = jsonGenerator.getOutputContext().getCurrentName();
            fieldName = fieldName.concat(this.dictHandle.getSuffix());
            jsonGenerator.writeObjectField(fieldName, content);
        }
    }

    public void setDict(Dict dict) {
        this.dict = dict;
    }

    public Object getDictContent(Dict dict, String fieldValue) {
        String[] dictPairs;
        if ("".equals(dict.dictMap()) && "".equals(dict.dictCode())) {
            return null;
        }
        if ("".equals(dict.dictMap().trim())) {
            return this.dictHandle.getDictContent(dict, fieldValue);
        }
        String converter = dict.dictMap();
        for (String dictPair : dictPairs = converter.split(dict.sepDict())) {
            String[] keyValue = dictPair.split(dict.sepPair());
            if (!fieldValue.equals(keyValue[0])) continue;
            return keyValue[1];
        }
        return null;
    }

    public DictHandle getDictHandle() {
        return this.dictHandle;
    }
}

