/*
 * Decompiled with CFR 0.152.
 */
package com.gltqe.mask;

import java.util.Collections;

public class DataMaskUtil {
    public static String maskName(String name) {
        if (name == null || name.isEmpty()) {
            return "";
        }
        return name.substring(0, 1) + String.join((CharSequence)"", Collections.nCopies(name.length() - 1, "*"));
    }

    public static String maskPhone(String phone) {
        if (phone == null || phone.isEmpty()) {
            return "";
        }
        return phone.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
    }

    public static String maskIdCard(String idCard) {
        if (idCard == null || idCard.isEmpty()) {
            return "";
        }
        return idCard.replaceAll("(\\d{4})\\d+(\\w{4})", "$1**********$2");
    }

    public static String maskBankCard(String bankCard) {
        if (bankCard == null || bankCard.isEmpty()) {
            return "";
        }
        return bankCard.replaceAll("(\\d{4})\\d+(\\d{4})", "$1**********$2");
    }

    public static String maskEmail(String email) {
        Integer partsLength = 2;
        if (email == null || email.isEmpty()) {
            return "";
        }
        String[] parts = email.split("@");
        if (parts.length != partsLength) {
            return email;
        }
        return parts[0].substring(0, 1) + "****@" + parts[1];
    }

    public static String maskAddress(String address) {
        Integer addressLength = 5;
        if (address == null || address.isEmpty()) {
            return "";
        }
        if (address.length() <= addressLength) {
            return address;
        }
        return address.substring(0, 3) + "**" + address.substring(address.length() - 2);
    }

    public static String maskIpAddress(String ipAddress) {
        Integer partsLength = 4;
        if (ipAddress == null || ipAddress.isEmpty()) {
            return "";
        }
        String[] parts = ipAddress.split("\\.");
        if (parts.length != partsLength) {
            return ipAddress;
        }
        return parts[0] + "." + parts[1] + "." + parts[2] + ".*";
    }

    public static String defaultMask(String data) {
        if (data == null || data.isEmpty()) {
            return "";
        }
        if (data.length() == 1) {
            return data.charAt(0) + "*";
        }
        return data.charAt(0) + "******";
    }
}

