/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.domain.branch;

public enum BranchRestrictionEnumType {
    FAST_FORWARD_ONLY("Rewriting history", "fast-forward-only", "prevents history rewrites on the specified branch(es) - for example by a force push or rebase."),
    NO_DELETES("Deletion", "no-deletes", "prevents branch and tag deletion"),
    PULL_REQUEST_ONLY("Changes without a pull request", "pull-request-only", "prevents pushing changes directly to the specified branch(es); changes are allowed only with a pull request"),
    READ_ONLY("All changes", "read-only", "prevents pushes to the specified branch(es) and restricts creating new branches matching the specified branch(es) or pattern");

    private final String name;
    private final String apiName;
    private final String description;

    private BranchRestrictionEnumType(String name, String apiName, String description) {
        this.name = name;
        this.apiName = apiName;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getDescription() {
        return this.description;
    }

    public static BranchRestrictionEnumType fromValue(String apiName) {
        for (BranchRestrictionEnumType enumType : BranchRestrictionEnumType.values()) {
            if (!enumType.getApiName().equals(apiName)) continue;
            return enumType;
        }
        throw new IllegalArgumentException("Value " + apiName + " is not a legal BranchPermission type");
    }

    public String toString() {
        return this.getApiName();
    }
}

