/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.domain.comment;

import com.cdancy.bitbucket.rest.domain.comment.AutoValue_Anchor;
import com.google.auto.value.AutoValue;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class Anchor {
    @Nullable
    public abstract Integer line();

    @Nullable
    public abstract String lineType();

    @Nullable
    public abstract String fileType();

    public abstract String path();

    @Nullable
    public abstract String srcPath();

    Anchor() {
    }

    @SerializedNames(value={"line", "lineType", "fileType", "path", "srcPath"})
    public static Anchor create(Integer line, LineType lineType, FileType fileType, String path, String srcPath) {
        return new AutoValue_Anchor(line, lineType != null ? lineType.toString() : null, fileType != null ? fileType.toString() : null, path, srcPath);
    }

    @SerializedNames(value={"line", "lineType", "fileType", "path", "srcPath"})
    public static Anchor create(Integer line, String lineType, String fileType, String path, String srcPath) {
        String possibleLineType = null;
        if (lineType != null) {
            for (LineType type : LineType.values()) {
                String foundType = type.toString();
                if (!foundType.equalsIgnoreCase(lineType)) continue;
                possibleLineType = foundType;
                break;
            }
            if (possibleLineType == null) {
                throw new RuntimeException("Unrecognized lineType '" + lineType + "'");
            }
        }
        String possibleFileType = null;
        if (fileType != null) {
            for (FileType type : FileType.values()) {
                String foundType = type.toString();
                if (!foundType.equalsIgnoreCase(fileType)) continue;
                possibleFileType = foundType;
                break;
            }
            if (possibleFileType == null) {
                throw new RuntimeException("Unrecognized fileType '" + fileType + "'");
            }
        }
        return new AutoValue_Anchor(line, possibleLineType, possibleFileType, path, srcPath);
    }

    public static enum FileType {
        FROM,
        TO;

    }

    public static enum LineType {
        ADDED,
        REMOVED,
        CONTEXT;

    }
}

