/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.domain.repository;

import com.cdancy.bitbucket.rest.BitbucketUtils;
import com.cdancy.bitbucket.rest.domain.common.Error;
import com.cdancy.bitbucket.rest.domain.common.ErrorsHolder;
import com.cdancy.bitbucket.rest.domain.repository.AutoValue_WebHook;
import com.cdancy.bitbucket.rest.domain.repository.WebHookConfiguration;
import com.google.auto.value.AutoValue;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class WebHook
implements ErrorsHolder {
    @Nullable
    public abstract String id();

    @Nullable
    public abstract String name();

    public abstract long createdDate();

    public abstract long updatedDate();

    @Nullable
    public abstract List<EventType> events();

    @Nullable
    public abstract WebHookConfiguration configuration();

    @Nullable
    public abstract String url();

    public abstract boolean active();

    WebHook() {
    }

    @SerializedNames(value={"id", "name", "createdDate", "updatedDate", "events", "configuration", "url", "active", "errors"})
    public static WebHook create(String id, String name, long createdDate, long updatedDate, @Nullable List<EventType> events, WebHookConfiguration configuration, String url, boolean active, @Nullable List<Error> errors) {
        return new AutoValue_WebHook(BitbucketUtils.nullToEmpty(errors), id, name, createdDate, updatedDate, BitbucketUtils.nullToEmpty(events), configuration, url, active);
    }

    public static enum EventType {
        REPO_COMENT_ADDED("repo:comment:added"),
        REPO_COMENT_EDITED("repo:comment:edited"),
        REPO_COMENT_DELETED("repo:comment:deleted"),
        REPO_FORKED("repo:forked"),
        REPO_CHANGED("repo:refs_changed"),
        REPO_MODIFIED("repo:modified"),
        PR_COMMENT_ADDED("pr:comment:added"),
        PR_COMMENT_EDITED("pr:comment:edited"),
        PR_COMMENT_DELETED("pr:comment:deleted"),
        PR_REVIEWER_UPDATE("pr:reviewer:updated"),
        PR_REVIEWER_UNAPPROVED("pr:reviewer:unapproved"),
        PR_REVIEWER_APPROVED("pr:reviewer:approved"),
        PR_REVIEWER_NEEDSWORK("pr:reviewer:needs_work"),
        PR_DELETED("pr:deleted"),
        PR_MERGED("pr:merged"),
        PR_MODIFIED("pr:modified"),
        PR_DECLINED("pr:declined"),
        PR_OPENED("pr:opened"),
        PR_FROM_REF_UPDATED("pr:from_ref_updated");

        private final String apiName;

        private EventType(String apiName) {
            this.apiName = apiName;
        }

        public String getApiName() {
            return this.apiName;
        }

        public static EventType fromValue(String apiName) {
            for (EventType enumType : EventType.values()) {
                if (!enumType.getApiName().equals(apiName)) continue;
                return enumType;
            }
            throw new IllegalArgumentException("Value " + apiName + " is not a legal EventType type");
        }

        public String toString() {
            return this.getApiName();
        }
    }
}

