/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.features;

import com.cdancy.bitbucket.rest.annotations.Documentation;
import com.cdancy.bitbucket.rest.domain.branch.Branch;
import com.cdancy.bitbucket.rest.domain.branch.BranchModel;
import com.cdancy.bitbucket.rest.domain.branch.BranchModelConfiguration;
import com.cdancy.bitbucket.rest.domain.branch.BranchPage;
import com.cdancy.bitbucket.rest.domain.branch.BranchRestriction;
import com.cdancy.bitbucket.rest.domain.branch.BranchRestrictionPage;
import com.cdancy.bitbucket.rest.domain.common.RequestStatus;
import com.cdancy.bitbucket.rest.fallbacks.BitbucketFallbacks;
import com.cdancy.bitbucket.rest.filters.BitbucketAuthenticationFilter;
import com.cdancy.bitbucket.rest.options.CreateBranch;
import com.cdancy.bitbucket.rest.options.CreateBranchModelConfiguration;
import com.cdancy.bitbucket.rest.parsers.RequestStatusParser;
import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.binders.BindToJsonPayload;

@Produces(value={"application/json"})
@RequestFilters(value={BitbucketAuthenticationFilter.class})
@Path(value="/rest")
public interface BranchApi {
    @Named(value="branch:list")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45295356999632"})
    @Consumes(value={"application/json"})
    @Path(value="/api/{jclouds.api-version}/projects/{project}/repos/{repo}/branches")
    @Fallback(value=BitbucketFallbacks.BranchPageOnError.class)
    @GET
    public BranchPage list(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @Nullable @QueryParam(value="base") String var3, @Nullable @QueryParam(value="details") String var4, @Nullable @QueryParam(value="filterText") String var5, @Nullable @QueryParam(value="orderBy") String var6, @Nullable @QueryParam(value="start") Integer var7, @Nullable @QueryParam(value="limit") Integer var8);

    @Named(value="branch:create")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45295357022352"})
    @Consumes(value={"application/json"})
    @Path(value="/branch-utils/{jclouds.api-version}/projects/{project}/repos/{repo}/branches")
    @Fallback(value=BitbucketFallbacks.BranchOnError.class)
    @POST
    public Branch create(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @BinderParam(value=BindToJsonPayload.class) CreateBranch var3);

    @Named(value="branch:delete")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/4.10.0/bitbucket-branch-rest.html#idp47888"})
    @Consumes(value={"application/json"})
    @Path(value="/branch-utils/{jclouds.api-version}/projects/{project}/repos/{repo}/branches")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @Payload(value="%7B \"name\": \"{branchPath}\" %7D")
    @DELETE
    public RequestStatus delete(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PayloadParam(value="branchPath") String var3);

    @Named(value="branch:update-default")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45295356975264"})
    @Consumes(value={"application/json"})
    @Path(value="/api/{jclouds.api-version}/projects/{project}/repos/{repo}/branches/default")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @Payload(value="%7B \"id\": \"{id}\" %7D")
    @PUT
    public RequestStatus updateDefault(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PayloadParam(value="id") String var3);

    @Named(value="branch:get-default")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45295356984528"})
    @Consumes(value={"application/json"})
    @Path(value="/api/{jclouds.api-version}/projects/{project}/repos/{repo}/branches/default")
    @Fallback(value=BitbucketFallbacks.BranchOnError.class)
    @GET
    public Branch getDefault(@PathParam(value="project") String var1, @PathParam(value="repo") String var2);

    @Named(value="branch:model")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/4.10.0/bitbucket-branch-rest.html#idp27168"})
    @Consumes(value={"application/json"})
    @Path(value="/branch-utils/{jclouds.api-version}/projects/{project}/repos/{repo}/branchmodel")
    @Fallback(value=BitbucketFallbacks.BranchModelOnError.class)
    @GET
    public BranchModel model(@PathParam(value="project") String var1, @PathParam(value="repo") String var2);

    @Named(value="branch:info")
    @Documentation(value={"https://docs.atlassian.com/DAC/rest/stash/2.12.1/stash-branch-utils-rest.html#idp83520"})
    @Consumes(value={"application/json"})
    @Path(value="/branch-utils/{jclouds.api-version}/projects/{project}/repos/{repo}/branches/info/{commitId}")
    @Fallback(value=BitbucketFallbacks.BranchPageOnError.class)
    @GET
    public BranchPage info(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="commitId") String var3);

    @Named(value="branch:get-model-configuration")
    @Documentation(value={"https://jira.atlassian.com/browse/BSERV-5411"})
    @Consumes(value={"application/json"})
    @Path(value="/branch-utils/{jclouds.api-version}/projects/{project}/repos/{repo}/branchmodel/configuration")
    @Fallback(value=BitbucketFallbacks.BranchModelConfigurationOnError.class)
    @GET
    public BranchModelConfiguration getModelConfiguration(@PathParam(value="project") String var1, @PathParam(value="repo") String var2);

    @Named(value="branch:update-model-configuration")
    @Documentation(value={"https://jira.atlassian.com/browse/BSERV-5411"})
    @Consumes(value={"application/json"})
    @Path(value="/branch-utils/{jclouds.api-version}/projects/{project}/repos/{repo}/branchmodel/configuration")
    @Fallback(value=BitbucketFallbacks.BranchModelConfigurationOnError.class)
    @PUT
    public BranchModelConfiguration updateModelConfiguration(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @BinderParam(value=BindToJsonPayload.class) CreateBranchModelConfiguration var3);

    @Named(value="branch:delete-model-configuration")
    @Documentation(value={"https://jira.atlassian.com/browse/BSERV-5411"})
    @Consumes(value={"application/json"})
    @Path(value="/branch-utils/{jclouds.api-version}/projects/{project}/repos/{repo}/branchmodel/configuration")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @DELETE
    public RequestStatus deleteModelConfiguration(@PathParam(value="project") String var1, @PathParam(value="repo") String var2);

    @Named(value="branch:list-branch-permission")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/4.14.1/bitbucket-ref-restriction-rest.html#idm45354011023456"})
    @Consumes(value={"application/json"})
    @Path(value="/branch-permissions/2.0/projects/{project}/repos/{repo}/restrictions")
    @Fallback(value=BitbucketFallbacks.BranchPermissionPageOnError.class)
    @GET
    public BranchRestrictionPage listBranchRestriction(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @Nullable @QueryParam(value="start") Integer var3, @Nullable @QueryParam(value="limit") Integer var4);

    @Named(value="branch:update-branch-permission")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/4.14.1/bitbucket-ref-restriction-rest.html#idm45354011023456"})
    @Path(value="/branch-permissions/2.0/projects/{project}/repos/{repo}/restrictions")
    @Produces(value={"application/vnd.atl.bitbucket.bulk+json"})
    @Consumes(value={"application/json"})
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @POST
    public RequestStatus createBranchRestriction(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @BinderParam(value=BindToJsonPayload.class) List<BranchRestriction> var3);

    @Named(value="branch:delete-branch-permission")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/4.14.1/bitbucket-ref-restriction-rest.html#idm45354011023456"})
    @Consumes(value={"application/json"})
    @Path(value="/branch-permissions/2.0/projects/{project}/repos/{repo}/restrictions/{id}")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @DELETE
    public RequestStatus deleteBranchRestriction(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="id") long var3);
}

