/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.features;

import com.cdancy.bitbucket.rest.annotations.Documentation;
import com.cdancy.bitbucket.rest.domain.comment.Comments;
import com.cdancy.bitbucket.rest.domain.common.RequestStatus;
import com.cdancy.bitbucket.rest.domain.pullrequest.CommentPage;
import com.cdancy.bitbucket.rest.fallbacks.BitbucketFallbacks;
import com.cdancy.bitbucket.rest.filters.BitbucketAuthenticationFilter;
import com.cdancy.bitbucket.rest.options.CreateComment;
import com.cdancy.bitbucket.rest.parsers.RequestStatusParser;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.binders.BindToJsonPayload;

@Produces(value={"application/json"})
@RequestFilters(value={BitbucketAuthenticationFilter.class})
@Path(value="/rest/api/{jclouds.api-version}/projects")
public interface CommentsApi {
    @Named(value="comments:comment")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888278076336"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests/{pullRequestId}/comments")
    @Payload(value="%7B \"text\": \"{comment}\" %7D")
    @Fallback(value=BitbucketFallbacks.CommentsOnError.class)
    @POST
    public Comments comment(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="pullRequestId") int var3, @PayloadParam(value="comment") String var4);

    @Named(value="comments:create")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888278076336"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests/{pullRequestId}/comments")
    @Fallback(value=BitbucketFallbacks.CommentsOnError.class)
    @POST
    public Comments create(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="pullRequestId") int var3, @BinderParam(value=BindToJsonPayload.class) CreateComment var4);

    @Named(value="comments:get")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888278070112"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests/{pullRequestId}/comments/{commentId}")
    @Fallback(value=BitbucketFallbacks.CommentsOnError.class)
    @GET
    public Comments get(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="pullRequestId") int var3, @PathParam(value="commentId") int var4);

    @Deprecated
    @Named(value="comments:file-comments-deprecated")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888278617264"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests/{pullRequestId}/comments")
    @Fallback(value=BitbucketFallbacks.CommentPageOnError.class)
    @GET
    public CommentPage fileComments(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="pullRequestId") int var3, @QueryParam(value="path") String var4, @Nullable @QueryParam(value="start") Integer var5, @Nullable @QueryParam(value="limit") Integer var6);

    @Named(value="comments:file-comments")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888278617264"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests/{pullRequestId}/comments")
    @Fallback(value=BitbucketFallbacks.CommentPageOnError.class)
    @GET
    public CommentPage fileComments(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="pullRequestId") int var3, @QueryParam(value="path") String var4, @Nullable @QueryParam(value="anchorState") String var5, @Nullable @QueryParam(value="diffType") String var6, @Nullable @QueryParam(value="fromHash") String var7, @Nullable @QueryParam(value="toHash") String var8, @Nullable @QueryParam(value="start") Integer var9, @Nullable @QueryParam(value="limit") Integer var10);

    @Named(value="comments:delete")
    @Documentation(value={"https://developer.atlassian.com/static/rest/bitbucket-server/latest/bitbucket-rest.html#idm45888278021232"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/pull-requests/{pullRequestId}/comments/{commentId}")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @DELETE
    public RequestStatus delete(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="pullRequestId") int var3, @PathParam(value="commentId") int var4, @QueryParam(value="version") int var5);
}

