/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.features;

import com.cdancy.bitbucket.rest.annotations.Documentation;
import com.cdancy.bitbucket.rest.domain.common.RequestStatus;
import com.cdancy.bitbucket.rest.domain.postwebhooks.PostWebHook;
import com.cdancy.bitbucket.rest.fallbacks.BitbucketFallbacks;
import com.cdancy.bitbucket.rest.filters.BitbucketAuthenticationFilter;
import com.cdancy.bitbucket.rest.options.CreatePostWebHook;
import com.cdancy.bitbucket.rest.parsers.RequestStatusParser;
import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.binders.BindToJsonPayload;

@Produces(value={"application/json"})
@RequestFilters(value={BitbucketAuthenticationFilter.class})
@Path(value="/rest")
public interface PostWebHookApi {
    @Named(value="postwebhook:list")
    @Documentation(value={"https://support.cloudbees.com/hc/en-us/articles/115000083932-Generate-webHooks-in-Bitbucket-Server-via-REST-API-for-Pipeline-Multibranch?page=45#getexistingwebhooks"})
    @Consumes(value={"application/json"})
    @Path(value="/webhook/{jclouds.api-version}/projects/{project}/repos/{repo}/webhook/configurations")
    @GET
    public List<PostWebHook> list(@PathParam(value="project") String var1, @PathParam(value="repo") String var2);

    @Named(value="postwebhook:update-postwebhook")
    @Documentation(value={"https://support.cloudbees.com/hc/en-us/articles/115000083932-Generate-webHooks-in-Bitbucket-Server-via-REST-API-for-Pipeline-Multibranch?page=45#updateawebhookbyid"})
    @Consumes(value={"application/json"})
    @Path(value="/webhook/{jclouds.api-version}/projects/{project}/repos/{repo}/webhook/configurations/{postWebHookId}")
    @Fallback(value=BitbucketFallbacks.PostWebHookOnError.class)
    @PUT
    public PostWebHook update(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="postWebHookId") String var3, @BinderParam(value=BindToJsonPayload.class) CreatePostWebHook var4);

    @Named(value="postwebhook:create-postwebhook")
    @Documentation(value={"https://support.cloudbees.com/hc/en-us/articles/115000083932-Generate-webHooks-in-Bitbucket-Server-via-REST-API-for-Pipeline-Multibranch?page=45#createawebhook"})
    @Consumes(value={"application/json"})
    @Path(value="/webhook/{jclouds.api-version}/projects/{project}/repos/{repo}/webhook/configurations")
    @Fallback(value=BitbucketFallbacks.PostWebHookOnError.class)
    @POST
    public PostWebHook create(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @BinderParam(value=BindToJsonPayload.class) CreatePostWebHook var3);

    @Named(value="postwebhook:delete-postwebhook")
    @Documentation(value={"https://support.cloudbees.com/hc/en-us/articles/115000083932-Generate-webHooks-in-Bitbucket-Server-via-REST-API-for-Pipeline-Multibranch?page=45#createawebhook"})
    @Consumes(value={"application/json"})
    @Path(value="/webhook/{jclouds.api-version}/projects/{project}/repos/{repo}/webhook/configurations/{postWebHookId}")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @DELETE
    public RequestStatus delete(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="postWebHookId") String var3);
}

