/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.features;

import com.cdancy.bitbucket.rest.annotations.Documentation;
import com.cdancy.bitbucket.rest.domain.common.RequestStatus;
import com.cdancy.bitbucket.rest.domain.repository.WebHook;
import com.cdancy.bitbucket.rest.domain.repository.WebHookPage;
import com.cdancy.bitbucket.rest.fallbacks.BitbucketFallbacks;
import com.cdancy.bitbucket.rest.filters.BitbucketAuthenticationFilter;
import com.cdancy.bitbucket.rest.options.CreateWebHook;
import com.cdancy.bitbucket.rest.parsers.RequestStatusParser;
import com.google.inject.name.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.binders.BindToJsonPayload;

@Produces(value={"application/json"})
@RequestFilters(value={BitbucketAuthenticationFilter.class})
@Path(value="/rest/api/{jclouds.api-version}/projects")
public interface WebHookApi {
    @Named(value="webhook:list-webhook")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/5.14.1/bitbucket-rest.html#idm45367160971744"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/webhooks")
    @Fallback(value=BitbucketFallbacks.WebHookPageOnError.class)
    @GET
    public WebHookPage list(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @Nullable @QueryParam(value="start") Integer var3, @Nullable @QueryParam(value="limit") Integer var4);

    @Named(value="webhook:get-webhook")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/5.14.1/bitbucket-rest.html#idm45367160920544"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/webhooks/{webHookKey}")
    @Fallback(value=BitbucketFallbacks.WebHookOnError.class)
    @GET
    public WebHook get(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="webHookKey") String var3);

    @Named(value="webhook:create-webhook")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/5.14.1/bitbucket-rest.html#idm45367160974656"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/webhooks")
    @Fallback(value=BitbucketFallbacks.WebHookOnError.class)
    @POST
    public WebHook create(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @BinderParam(value=BindToJsonPayload.class) CreateWebHook var3);

    @Named(value="webhook:update-webhook")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/5.14.1/bitbucket-rest.html#idm45367160908160"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/webhooks/{webHookKey}")
    @Fallback(value=BitbucketFallbacks.WebHookOnError.class)
    @PUT
    public WebHook update(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="webHookKey") String var3, @BinderParam(value=BindToJsonPayload.class) CreateWebHook var4);

    @Named(value="webhook:delete-webhook")
    @Documentation(value={"https://docs.atlassian.com/bitbucket-server/rest/5.14.1/bitbucket-rest.html#idm45367160891616"})
    @Consumes(value={"application/json"})
    @Path(value="/{project}/repos/{repo}/webhooks/{webHookKey}")
    @Fallback(value=BitbucketFallbacks.RequestStatusOnError.class)
    @ResponseParser(value=RequestStatusParser.class)
    @DELETE
    public RequestStatus delete(@PathParam(value="project") String var1, @PathParam(value="repo") String var2, @PathParam(value="webHookKey") String var3);
}

