/*
 * Decompiled with CFR 0.152.
 */
package com.cdancy.bitbucket.rest.filters;

import javax.inject.Singleton;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;

@Singleton
public class ScrubNullFromPathFilter
implements HttpRequestFilter {
    private static final String SCRUB_NULL_PARAM = "%7B.+?%7D";
    private static final String FORWARD_SLASH = "/";
    private static final String DOUBLE_FORWARD_SLASH = "\\/\\/";
    private static final String EMPTY_STRING = "";
    private static final char FORWARD_SLASH_CHAR = '/';

    public HttpRequest filter(HttpRequest request) throws HttpException {
        String requestPath = request.getEndpoint().getRawPath().replaceAll(SCRUB_NULL_PARAM, EMPTY_STRING).replaceAll(DOUBLE_FORWARD_SLASH, FORWARD_SLASH);
        if (requestPath.charAt(requestPath.length() - 1) == '/') {
            requestPath = requestPath.substring(0, requestPath.length() - 1);
        }
        return request.toBuilder().replacePath(requestPath).build();
    }
}

