/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class FileUtil {
    public static String createProfileDir(String prefix) {
        try {
            return Files.createTempDirectory(prefix, new FileAttribute[0]).toRealPath(new LinkOption[0]).toString();
        }
        catch (Exception e) {
            throw new RuntimeException("create temp profile dir fail:", e);
        }
    }

    public static boolean assertExecutable(String executablePath) {
        Path path = Paths.get(executablePath, new String[0]);
        return Files.isRegularFile(path, new LinkOption[0]) && Files.isReadable(path) && Files.isExecutable(path);
    }

    public static void removeFolder(String path) {
        File file = new File(path);
        FileUtil.delete(file);
    }

    private static void delete(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null && files.length > 0) {
                for (File f : files) {
                    FileUtil.delete(f);
                }
            }
            file.deleteOnExit();
        } else {
            file.deleteOnExit();
        }
    }

    public static final void createNewFile(File file) throws IOException {
        if (!file.exists()) {
            FileUtil.mkdir(file.getParentFile());
            file.createNewFile();
        }
    }

    public static final void mkdir(File parent) {
        if (parent != null && !parent.exists()) {
            FileUtil.mkdir(parent.getParentFile());
            parent.mkdir();
        }
    }
}

