/*
 * Decompiled with CFR 0.152.
 */
package safayat.orm.config;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import safayat.orm.annotation.Table;
import safayat.orm.interfaces.ConnectionPoolInterface;
import safayat.orm.jdbcUtility.TableMetadata;
import safayat.orm.reflect.FileManager;
import safayat.orm.reflect.ReflectUtility;
import safayat.orm.reflect.Util;

public class ConfigManager {
    Logger logger = Logger.getLogger(ConfigManager.class.getName());
    private static ConfigManager ourInstance = new ConfigManager();
    private Map<String, Map<String, Class>> classByDatabaseAndTable;
    private Map<String, TableMetadata> tableMetadataMap;
    private String dbUserName;
    private String dbPassword;
    private String dbName;
    private String dbUrl;
    private String dbDriverName;
    private String modelPackageName;
    ConnectionPoolInterface connectionPool;

    public static ConfigManager getInstance() {
        return ourInstance;
    }

    public void setConnectionPool(ConnectionPoolInterface connectionPoolInterface) {
        if (this.connectionPool == null) {
            this.connectionPool = connectionPoolInterface;
        }
    }

    private ConfigManager() {
        try {
            this.readProperties();
            this.classByDatabaseAndTable = this.parseModelPackageAndGenerateTableClassMap();
            this.tableMetadataMap = new HashMap<String, TableMetadata>();
            this.readAndCacheDatabaseMetadata(this.getDbName());
            this.logger.log(Level.INFO, "succecssfully read configuration data");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.log(Level.SEVERE, "FAILED to initialize config manager. error is:" + e.getMessage());
        }
    }

    private void readProperties() throws IOException {
        Properties properties = new Properties();
        String propertyFileName = "database.properties";
        properties.load(this.getClass().getClassLoader().getResourceAsStream(propertyFileName));
        this.dbUserName = properties.getProperty("db.user");
        this.dbUrl = properties.getProperty("db.url");
        this.dbPassword = properties.getProperty("db.password");
        this.modelPackageName = properties.getProperty("db.model.package");
        this.dbName = properties.getProperty("db.name");
        this.dbDriverName = properties.getProperty("db.driver");
        this.logger.log(Level.INFO, "read properties: dbName : " + this.dbName + "\n, dbUserName:" + this.dbUserName + "\n, dbUrl:" + this.dbUrl + "\n, modelPackageName:" + this.modelPackageName + "\n, dbDriverName:" + this.dbDriverName + ".");
    }

    private Map<String, Map<String, Class>> parseModelPackageAndGenerateTableClassMap() {
        HashMap<String, Map<String, Class>> classByTableAndDatabase = new HashMap<String, Map<String, Class>>();
        Class[] tableClasses = null;
        try {
            for (Class tableClazz : tableClasses = FileManager.getClasses(this.modelPackageName)) {
                HashMap<String, Class> classByTable;
                Table annotation = tableClazz.getAnnotation(Table.class);
                String tableName = tableClazz.getSimpleName();
                String databaseName = this.dbName;
                if (annotation != null) {
                    Table table = annotation;
                    databaseName = table.databaseName().isEmpty() ? this.dbName : table.databaseName();
                    tableName = table.name();
                }
                if ((classByTable = (HashMap<String, Class>)classByTableAndDatabase.get(databaseName)) == null) {
                    classByTable = new HashMap<String, Class>();
                    classByTableAndDatabase.put(databaseName, classByTable);
                }
                classByTable.put(tableName.toLowerCase(), tableClazz);
                this.logger.log(Level.INFO, "tablename: " + tableName + " class: " + tableClazz.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return classByTableAndDatabase;
    }

    public Class getClassByTableName(String table) {
        return this.getClassByTableName(table, this.dbName);
    }

    public String getTableName(Class tableClass) {
        return this.getTableMetadata(tableClass).getTableName();
    }

    public Class getClassByTableName(String table, String databaseName) {
        Class tableClass = null;
        if (this.classByDatabaseAndTable.containsKey(databaseName)) {
            tableClass = this.classByDatabaseAndTable.get(databaseName).get(table.toLowerCase());
        }
        return tableClass;
    }

    public String getDbUserName() {
        return this.dbUserName;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public String getDbDriverName() {
        return this.dbDriverName;
    }

    public String getModelPackageName() {
        return this.modelPackageName;
    }

    public Connection getConnection() throws SQLException {
        if (this.connectionPool != null) {
            return this.connectionPool.getConnection();
        }
        return DriverManager.getConnection(this.dbUrl, this.dbUserName, this.dbPassword);
    }

    private void readAndCacheDatabaseMetadata(String databaseName) throws Exception {
        Connection connection = this.getConnection();
        String[] types = new String[]{"TABLE"};
        ResultSet resultSet = connection.getMetaData().getTables(databaseName, null, "", types);
        ArrayList<String> tableNames = new ArrayList<String>();
        while (resultSet.next()) {
            tableNames.add(resultSet.getString("TABLE_NAME"));
        }
        resultSet.close();
        for (String tableName : tableNames) {
            Class tableClass = this.getClassByTableName(tableName, databaseName);
            if (tableClass == null) continue;
            resultSet = connection.getMetaData().getPrimaryKeys(this.getDbName(), null, tableName);
            TableMetadata tableMetadata = new TableMetadata(tableName, this.getDbName(), tableClass, ReflectUtility.getRelationAnnotations(tableClass));
            while (resultSet.next()) {
                String columnName = resultSet.getString(4);
                tableMetadata.addPrimaryKey(columnName, null);
                tableMetadata.addClassPrimaryKey(columnName, null);
            }
            resultSet.close();
            this.readPrimaryKeyAndUpdateTableInfo(connection, databaseName, tableName, tableMetadata);
            this.tableMetadataMap.put(tableClass.getName(), tableMetadata);
            this.logger.log(Level.INFO, tableClass.getName());
        }
    }

    private void readPrimaryKeyAndUpdateTableInfo(Connection connection, String databaseName, String tableName, TableMetadata tableMetadata) throws SQLException {
        for (String primaryKey : tableMetadata.getPrimaryKeys()) {
            ResultSet resultSet1 = connection.getMetaData().getColumns(databaseName, null, tableName, primaryKey);
            while (resultSet1.next()) {
                Class primaryKeyType = Util.getClassByMysqlType(resultSet1.getInt("DATA_TYPE"));
                boolean autoIncrement = resultSet1.getString("IS_AUTOINCREMENT").equalsIgnoreCase("YES");
                tableMetadata.addPrimaryKey(primaryKey, primaryKeyType);
                tableMetadata.setIsAutoIncrement(autoIncrement);
                Class tableAsClass = this.getClassByTableName(tableMetadata.getTableName());
                try {
                    Class<?> primaryKeyTypeInClass = tableAsClass.getDeclaredField(primaryKey).getType();
                    tableMetadata.addClassPrimaryKey(primaryKey, primaryKeyTypeInClass);
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
            resultSet1.close();
        }
    }

    public TableMetadata getTableMetadata(String tableName) {
        return this.tableMetadataMap.get(this.getClassByTableName(tableName).getName());
    }

    public TableMetadata getTableMetadata(Class table) {
        return this.tableMetadataMap.get(table.getName());
    }

    public boolean havePrimaryKey(Class table) throws Exception {
        TableMetadata tableMetadata = this.getTableMetadata(table);
        return tableMetadata != null && tableMetadata.getPrimaryKeyDbTypeByName().size() > 0;
    }
}

