/*
 * Decompiled with CFR 0.152.
 */
package safayat.orm.dao;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import safayat.orm.annotation.ManyToOne;
import safayat.orm.annotation.OneToMany;
import safayat.orm.annotation.Table;
import safayat.orm.config.ConfigManager;
import safayat.orm.jdbcUtility.ResultSetUtility;
import safayat.orm.jdbcUtility.TableMetadata;
import safayat.orm.reflect.ReflectUtility;
import safayat.orm.reflect.RelationInfo;
import safayat.orm.reflect.Util;

public class GeneralRepository {
    private Connection getConnection() throws SQLException {
        return ConfigManager.getInstance().getConnection();
    }

    public ResultSetUtility executeQuery(String sql) {
        Connection dbConnection = null;
        PreparedStatement statement = null;
        try {
            dbConnection = this.getConnection();
            statement = dbConnection.prepareStatement(sql);
            ResultSet rs = statement.executeQuery();
            try {
                return new ResultSetUtility(rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.closeResourcesSafely(dbConnection, statement);
        }
        return null;
    }

    public Object execute(String sql) throws SQLException {
        return this.execute(sql, this.getConnection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, Connection dbConnection) throws SQLException {
        Statement statement = null;
        try {
            statement = dbConnection.createStatement();
            boolean bl = statement.execute(sql);
            return bl;
        }
        finally {
            this.closeResourcesSafely(null, statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeInsert(Object singleRow, Connection dbConnection) throws Exception {
        Statement statement = null;
        Object autoGeneratedPrimaryKey = null;
        try {
            statement = dbConnection.createStatement();
            statement.executeUpdate(ReflectUtility.createInsertSqlString(singleRow), 1);
            TableMetadata tableMetadata = ConfigManager.getInstance().getTableMetadata(singleRow.getClass());
            Class type = tableMetadata.getKeyType(tableMetadata.getSinglePrimaryKey());
            if (tableMetadata.isAutoIncrement()) {
                ResultSet rs = statement.getGeneratedKeys();
                if (rs.next()) {
                    autoGeneratedPrimaryKey = ReflectUtility.getColumnFromResultByGivenType(type, rs, 1);
                    this.updateObjectWithAutoGeneratedKey(singleRow, autoGeneratedPrimaryKey);
                }
                rs.close();
            }
        }
        finally {
            this.closeResourcesSafely(null, statement);
        }
        return autoGeneratedPrimaryKey;
    }

    private int[] executeBatch(String[] sqls) throws SQLException {
        return this.executeBatch(sqls, this.getConnection());
    }

    private int[] executeBatch(String[] sqls, Connection dbConnection) throws SQLException {
        Statement statement = null;
        try {
            statement = dbConnection.createStatement();
            for (String sql : sqls) {
                statement.addBatch(sql);
            }
            int[] nArray = statement.executeBatch();
            return nArray;
        }
        catch (SQLException sQLException) {
            throw new SQLException(sQLException.getMessage());
        }
        finally {
            this.closeResourcesSafely(null, statement);
        }
    }

    public <T> T get(Class<T> tClass, Object id) {
        Connection dbConnection = null;
        PreparedStatement statement = null;
        try {
            dbConnection = this.getConnection();
            Table table = tClass.getAnnotation(Table.class);
            List<String> primaryKeys = this.getPrimaryKeys(TableMetadata.getTableName(tClass), dbConnection);
            if (primaryKeys.isEmpty()) {
                throw new SQLException("Primary key not found");
            }
            if (primaryKeys.size() > 1) {
                throw new SQLException("Not applicable for composed primary keys");
            }
            StringBuilder sqlBuilder = new StringBuilder("select * from ").append(TableMetadata.getTableName(tClass)).append(" where ").append(primaryKeys.get(0)).append(" = ").append(Util.toMysqlString(id));
            statement = dbConnection.prepareStatement(sqlBuilder.toString());
            ResultSet rs = statement.executeQuery();
            if (rs != null && rs.next()) {
                ResultSetUtility resultSetUtility = new ResultSetUtility(rs);
                return resultSetUtility.mapRow(tClass);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.closeResourcesSafely(dbConnection, statement);
        }
        return null;
    }

    public <T> T mapSingleObject(Class<T> tClass, ResultSet resultSet) throws Exception {
        return new ResultSetUtility(resultSet).mapRow(tClass);
    }

    private boolean isInsertOperation(Object t) throws Exception {
        String tableName = TableMetadata.getTableName(t.getClass());
        TableMetadata tableMetadata = ConfigManager.getInstance().getTableMetadata(tableName);
        return tableMetadata == null || ReflectUtility.isPrimaryKeyEmpty(t, tableMetadata.getSinglePrimaryKey()) && tableMetadata.isAutoIncrement();
    }

    private boolean isInvalidForInsertOrUpdate(Object t) throws Exception {
        String tableName = TableMetadata.getTableName(t.getClass());
        TableMetadata tableMetadata = ConfigManager.getInstance().getTableMetadata(tableName);
        return tableMetadata != null && !tableMetadata.isAutoIncrement() && ReflectUtility.isPrimaryKeyEmpty(t, tableMetadata.getSinglePrimaryKey());
    }

    public <T> void insert(T t) throws Exception {
        this.insert(t, this.getConnection());
    }

    private <T> Object insertOrUpdateSingleObject(T t, Connection connection) throws Exception {
        if (this.isInsertOperation(t)) {
            return this.executeInsert(t, connection);
        }
        this.update(t, connection);
        return null;
    }

    public void insertOrUpdate(Object tree) throws SQLException {
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        try {
            this.insertOrUpdate(tree, this.getConnection());
            connection.commit();
        }
        catch (Exception e) {
            connection.rollback();
        }
    }

    public void insertOrUpdate(Object tree, Connection connection) throws Exception {
        HashMap<Object, Boolean> executedNodes = new HashMap<Object, Boolean>();
        this.processRelationalInsertOrUpdate(tree, executedNodes, connection);
    }

    public <T> void insert(T t, Connection connection) throws Exception {
        Object key = this.executeInsert(t, connection);
        this.updateObjectWithAutoGeneratedKey(t, key);
    }

    public <T> int[] insert(List<T> objects) throws Exception {
        return this.insert(objects, this.getConnection());
    }

    public <T> int[] insert(List<T> objects, Connection connection) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        for (T o : objects) {
            sqls.add(ReflectUtility.createInsertSqlString(o));
        }
        return this.executeBatch(sqls.toArray(new String[0]), connection);
    }

    private void processRelationalInsertOrUpdate(Object t, Map<Object, Boolean> nodes, Connection connection) throws Exception {
        if (nodes.containsKey(t) || this.isInvalidForInsertOrUpdate(t)) {
            return;
        }
        Object generatedKey = this.insertOrUpdateSingleObject(t, connection);
        nodes.put(t, true);
        TableMetadata tableMetadata = ConfigManager.getInstance().getTableMetadata(t.getClass());
        for (RelationInfo annotation : tableMetadata.getRelationInfos(OneToMany.class)) {
            List childs = (List)ReflectUtility.parseFieldValueFromObject(t, annotation.getFieldName());
            if (childs == null) continue;
            this.updateChildsWithAutoGeneratedKeys(childs, generatedKey, annotation.getMatchingColumn());
            for (Object o : childs) {
                this.processRelationalInsertOrUpdate(o, nodes, connection);
            }
        }
        for (RelationInfo annotation : tableMetadata.getRelationInfos(ManyToOne.class)) {
            Object child = ReflectUtility.parseFieldValueFromObject(t, annotation.getFieldName());
            if (child == null) continue;
            this.processRelationalInsertOrUpdate(child, nodes, connection);
        }
    }

    private void updateChildsWithAutoGeneratedKeys(List<Object> childs, Object autoGeneratedKey, String fieldName) throws Exception {
        if (autoGeneratedKey == null || childs.isEmpty()) {
            return;
        }
        for (Object o : childs) {
            Class fieldClass = Util.getFieldClass(o.getClass(), fieldName);
            ReflectUtility.mapValue(o, fieldName, fieldClass, autoGeneratedKey);
        }
    }

    private void updateObjectWithAutoGeneratedKey(Object o, Object autoGeneratedKey) throws Exception {
        if (autoGeneratedKey == null) {
            return;
        }
        TableMetadata tableMetadata = ConfigManager.getInstance().getTableMetadata(o.getClass());
        ReflectUtility.mapValue(o, tableMetadata.getSinglePrimaryKey(), tableMetadata.getClassKeyType(tableMetadata.getSinglePrimaryKey()), autoGeneratedKey);
    }

    public void update(Object t) throws Exception {
        this.update(t, this.getConnection());
    }

    public void update(Object t, Connection connection) throws Exception {
        this.execute(ReflectUtility.createSingleRowUpdateSqlString(t));
    }

    public <T> int[] update(List<T> objects) throws Exception {
        return this.update(objects, this.getConnection());
    }

    public <T> int[] update(List<T> objects, Connection connection) throws Exception {
        ArrayList<String> sqls = new ArrayList<String>();
        for (T o : objects) {
            sqls.add(ReflectUtility.createSingleRowUpdateSqlString(o));
        }
        return this.executeBatch(sqls.toArray(new String[0]), connection);
    }

    public <T> List<T> getAll(Class<T> tClass, String sql) {
        ResultSetUtility resultSetUtility = this.executeQuery(sql);
        try {
            if (resultSetUtility != null) {
                List<T> result = resultSetUtility.mapResultsetToObjects(tClass);
                resultSetUtility.close();
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public <T> List<T> getAll(Class<T> tClass) {
        return this.getAll(tClass, "select * from " + TableMetadata.getTableName(tClass));
    }

    public <T> List<T> getAll(Class<T> tClass, int limit) {
        return this.getAll(tClass, "select * from " + TableMetadata.getTableName(tClass) + " limit " + limit);
    }

    public <T> List<T> getAll(Class<T> tClass, int limit, int offset) {
        return this.getAll(tClass, "select * from " + TableMetadata.getTableName(tClass) + " limit " + limit + " offset " + offset);
    }

    public <T> List<T> mapResultSetToObjects(Class<T> tClass, ResultSet resultSet) {
        try {
            return new ResultSetUtility(resultSet).mapResultsetToObjects(tClass);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<String> getPrimaryKeys(String table, Connection connection) {
        ArrayList<String> primaryKeys = new ArrayList<String>();
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet rs = metaData.getPrimaryKeys(ConfigManager.getInstance().getDbName(), null, table);
            while (rs.next()) {
                primaryKeys.add(rs.getString("column_name"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return primaryKeys;
    }

    private List<String> findPrimaryKeys(Object row, Connection connection) {
        Table tableAnnotation = row.getClass().getAnnotation(Table.class);
        List<String> primaryKeys = new ArrayList<String>();
        if (tableAnnotation != null && !tableAnnotation.primaryKeyColumn().isEmpty()) {
            String[] primaryKeysInAnnotation;
            primaryKeys = new ArrayList();
            for (String pKey : primaryKeysInAnnotation = tableAnnotation.primaryKey().split(",")) {
                primaryKeys.add(pKey.trim());
            }
        }
        if (primaryKeys.isEmpty()) {
            primaryKeys = this.getPrimaryKeys(TableMetadata.getTableName(row.getClass()), connection);
        }
        return primaryKeys;
    }

    private void closeResourcesSafely(Connection dbConnection, Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        if (dbConnection != null) {
            try {
                dbConnection.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
    }
}

