/*
 * Decompiled with CFR 0.152.
 */
package safayat.orm.jdbcUtility;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResultSetMetadataUtility {
    private ResultSetMetaData resultSetMetaData;
    private Map<String, List<Integer>> columnsByTable;
    private Map<String, Integer> tableIndexByName;
    private String[] tables;

    public ResultSetMetadataUtility(ResultSetMetaData resultSetMetaData) {
        this.resultSetMetaData = resultSetMetaData;
        this.tables = this.getColumnIndexesByTable().keySet().toArray(new String[0]);
        this.tableIndexByName = new HashMap<String, Integer>();
        for (int i = 0; i < this.tables.length; ++i) {
            this.tableIndexByName.put(this.tables[i], i);
        }
    }

    public ResultSetMetaData get() {
        return this.resultSetMetaData;
    }

    public Map<String, List<Integer>> getColumnIndexesByTable() {
        if (this.columnsByTable == null) {
            this.columnsByTable = new HashMap<String, List<Integer>>();
            try {
                for (int column = 1; column <= this.resultSetMetaData.getColumnCount(); ++column) {
                    List columns = this.columnsByTable.getOrDefault(this.resultSetMetaData.getTableName(column).toLowerCase(), new ArrayList());
                    if (columns.size() == 0) {
                        this.columnsByTable.put(this.resultSetMetaData.getTableName(column).toLowerCase(), columns);
                    }
                    columns.add(column);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return this.columnsByTable;
    }

    public List<Integer> getColumnIndexes(String table) {
        return this.getColumnIndexesByTable().get(table.toLowerCase());
    }

    public int getColumnIndex(String tableName, String columnName) throws Exception {
        List<Integer> columnIndexes = this.getColumnIndexesByTable().get(tableName.toLowerCase());
        for (int index : columnIndexes) {
            String clName = this.resultSetMetaData.getColumnName(index);
            if (!columnName.equals(clName)) continue;
            return index;
        }
        return -1;
    }

    public int getCount() throws Exception {
        return this.resultSetMetaData.getColumnCount();
    }

    public String[] getTables() {
        return this.tables;
    }

    public Integer getTableIndex(String name) {
        return this.tableIndexByName.get(name.toLowerCase());
    }

    public Integer getTableCount() {
        return this.tables.length;
    }

    public String getTable(int index) {
        return this.tables[index];
    }
}

