/*
 * Decompiled with CFR 0.152.
 */
package safayat.orm.jdbcUtility;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import safayat.orm.config.ConfigManager;
import safayat.orm.jdbcUtility.MultipleTableRow;
import safayat.orm.jdbcUtility.ResultSetMetadataUtility;
import safayat.orm.jdbcUtility.SingleTableRow;
import safayat.orm.jdbcUtility.SingleTableRowMap;
import safayat.orm.jdbcUtility.TableMetadata;
import safayat.orm.reflect.ReflectUtility;
import safayat.orm.reflect.RelationGraph;
import safayat.orm.reflect.RelationInfo;
import safayat.orm.reflect.Util;

public class ResultSetUtility {
    private ResultSet resultSet;
    private ResultSetMetadataUtility metadata;

    public ResultSetUtility(ResultSet resultSet) throws Exception {
        this.resultSet = resultSet;
        this.metadata = new ResultSetMetadataUtility(resultSet.getMetaData());
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public ResultSetMetadataUtility getMetadata() {
        return this.metadata;
    }

    public boolean next() throws SQLException {
        return this.resultSet.next();
    }

    public String createTableKeyForCurrentRow(String table) {
        List<Integer> columnIndexes = this.metadata.getColumnIndexes(table);
        StringBuilder keyBuilder = new StringBuilder();
        for (int columnIndex : columnIndexes) {
            Object columnValue = null;
            try {
                columnValue = this.getColumnValue(columnIndex);
                keyBuilder.append(columnValue);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            keyBuilder.append(";");
        }
        return keyBuilder.toString();
    }

    public <T> T mapRow(Class<T> clazz) throws Exception {
        List<Integer> columnIndexes = this.metadata.getColumnIndexes(ConfigManager.getInstance().getTableName(clazz).toLowerCase());
        T newClazz = clazz.newInstance();
        for (int index : columnIndexes) {
            this.mapColumn(newClazz, index);
        }
        return newClazz;
    }

    public <T> void mapColumn(T row, int index) throws Exception {
        String columnName = this.metadata.get().getColumnName(index);
        int columnType = this.metadata.get().getColumnType(index);
        try {
            Object value = this.getColumnValue(index);
            String methodName = Util.toJavaMethodName(columnName, "set");
            Method method = row.getClass().getDeclaredMethod(methodName, Util.getClassByMysqlType(columnType));
            if (method != null) {
                method.invoke(row, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object getColumnValue(int index) throws Exception {
        int columnType = this.metadata.get().getColumnType(index);
        Object value = null;
        value = -5 == columnType ? Long.valueOf(this.getResultSet().getLong(index)) : (-2 == columnType ? Boolean.valueOf(this.getResultSet().getBoolean(index)) : (4 == columnType ? Integer.valueOf(this.getResultSet().getInt(index)) : (12 == columnType ? this.getResultSet().getString(index) : (91 == columnType ? this.getResultSet().getDate(index) : (93 == columnType ? this.getResultSet().getTimestamp(index) : (92 == columnType ? this.getResultSet().getTime(index) : (2004 == columnType ? this.getResultSet().getBlob(index) : (6 == columnType ? Float.valueOf(this.getResultSet().getFloat(index)) : (8 == columnType ? Double.valueOf(this.getResultSet().getDouble(index)) : (2003 == columnType ? this.getResultSet().getArray(index) : (3 == columnType ? this.getResultSet().getBigDecimal(index) : this.getResultSet().getObject(index))))))))))));
        return value;
    }

    private List<MultipleTableRow> processResultSetData() throws Exception {
        SingleTableRowMap singleTableRowMap = new SingleTableRowMap();
        ArrayList<MultipleTableRow> multipleTableRows = new ArrayList<MultipleTableRow>();
        while (this.getResultSet().next()) {
            MultipleTableRow multipleTableRow = new MultipleTableRow();
            for (int i = 0; i < this.metadata.getTableCount(); ++i) {
                String tableName = this.metadata.getTable(i);
                String tableKey = this.createTableKeyForCurrentRow(tableName);
                Class tableClass = ConfigManager.getInstance().getClassByTableName(tableName);
                SingleTableRow singleTableRow = singleTableRowMap.getSingleTableRow(tableName, tableKey);
                if (singleTableRow == null) {
                    Object childObject = this.mapRow(tableClass);
                    singleTableRow = new SingleTableRow(childObject, tableClass, tableName, tableKey);
                    singleTableRowMap.addNewRow(tableName, tableKey, singleTableRow);
                }
                multipleTableRow.addSingleRow(tableName, singleTableRow);
            }
            multipleTableRows.add(multipleTableRow);
        }
        return multipleTableRows;
    }

    public <T> List<T> mapResultsetToObjects(Class<T> clazz) throws Exception {
        String rootTableName = TableMetadata.getTableName(clazz);
        RelationGraph relationGraph = new RelationGraph(clazz);
        ParentChildRelationDataMapHandler parentChildRelationDataMapHandler = new ParentChildRelationDataMapHandler();
        ArrayList<Object> data = new ArrayList<Object>();
        List<MultipleTableRow> compressedRows = this.processResultSetData();
        for (MultipleTableRow multipleTableRow : compressedRows) {
            for (String table : this.metadata.getTables()) {
                String parentTable;
                SingleTableRow parentSingleTableRow;
                RelationInfo relationInfo;
                SingleTableRow singleTableRow = multipleTableRow.getSingleTableRowByTableName(table);
                if (singleTableRow.tableNameMaches(rootTableName) || singleTableRow.getType() == null || (relationInfo = relationGraph.getRelationInfo(singleTableRow.getType())) == null || parentChildRelationDataMapHandler.mappingExists(parentSingleTableRow = multipleTableRow.getSingleTableRowByTableName(parentTable = TableMetadata.getTableName(relationInfo.getParent())), singleTableRow)) continue;
                ReflectUtility.mapRelation(relationInfo, parentSingleTableRow.getRow(), singleTableRow.getRow());
                parentChildRelationDataMapHandler.addNewChildrenRow(parentSingleTableRow, singleTableRow);
            }
        }
        for (MultipleTableRow multipleTableRow : compressedRows) {
            data.add(multipleTableRow.getSingleTableRowByTableName(rootTableName).getRow());
        }
        return data;
    }

    public void close() {
        if (this.resultSet != null) {
            try {
                this.resultSet.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    class ParentChildRelationDataMapHandler {
        private Map<SingleTableRow, Map<SingleTableRow, Boolean>> parentChildRelationDataMap = new HashMap<SingleTableRow, Map<SingleTableRow, Boolean>>();

        public boolean mappingExists(SingleTableRow parent, SingleTableRow child) {
            Map<SingleTableRow, Boolean> childRowMap = this.parentChildRelationDataMap.get(parent);
            if (childRowMap != null) {
                return childRowMap.get(child) != null;
            }
            return false;
        }

        public void addNewChildrenRow(SingleTableRow parent, SingleTableRow child) {
            Map<SingleTableRow, Boolean> childRowMap = this.parentChildRelationDataMap.get(parent);
            if (childRowMap == null) {
                childRowMap = new HashMap<SingleTableRow, Boolean>();
                this.parentChildRelationDataMap.put(parent, childRowMap);
            }
            childRowMap.put(child, true);
        }
    }
}

