/*
 * Decompiled with CFR 0.152.
 */
package safayat.orm.jdbcUtility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import safayat.orm.config.ConfigManager;
import safayat.orm.reflect.RelationInfo;

public class TableMetadata {
    private Map<String, Class> primaryKeyDbTypeByName;
    private Map<String, Class> primaryKeyClassTypeByName;
    private String tableName;
    private String databaseName;
    private boolean isAutoIncrement;
    private Class tableClass;
    private List<RelationInfo> relationInfoListFoundInClass;

    public Class getTableClass() {
        return this.tableClass;
    }

    public TableMetadata(String tableName, String databaseName, Class tableClass, List<RelationInfo> relationInfos) throws Exception {
        this.tableName = tableName;
        this.databaseName = databaseName;
        this.primaryKeyDbTypeByName = new HashMap<String, Class>();
        this.primaryKeyClassTypeByName = new HashMap<String, Class>();
        this.tableClass = tableClass;
        this.relationInfoListFoundInClass = relationInfos;
    }

    public Map<String, Class> getPrimaryKeyDbTypeByName() {
        return this.primaryKeyDbTypeByName;
    }

    public void setPrimaryKeyDbTypeByName(Map<String, Class> primaryKeyDbTypeByName) {
        this.primaryKeyDbTypeByName = primaryKeyDbTypeByName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public boolean isAutoIncrement() {
        return this.isAutoIncrement;
    }

    public void setIsAutoIncrement(boolean isAutoIncrement) {
        this.isAutoIncrement = isAutoIncrement;
    }

    public Map<String, Class> getPrimaryKeyClassTypeByName() {
        return this.primaryKeyClassTypeByName;
    }

    public void setPrimaryKeyClassTypeByName(Map<String, Class> primaryKeyClassTypeByName) {
        this.primaryKeyClassTypeByName = primaryKeyClassTypeByName;
    }

    public String[] getPrimaryKeys() {
        return this.primaryKeyDbTypeByName.keySet().toArray(new String[0]);
    }

    public List<String> getPrimaryKeysAsList() {
        String[] primaryKeys = this.getPrimaryKeys();
        ArrayList<String> primaryKeyList = new ArrayList<String>();
        for (String key : primaryKeys) {
            primaryKeyList.add(key);
        }
        return primaryKeyList;
    }

    public String getSinglePrimaryKey() {
        return (String)this.primaryKeyDbTypeByName.keySet().toArray()[0];
    }

    public void addPrimaryKey(String key, Class type) {
        this.primaryKeyDbTypeByName.put(key, type);
    }

    public Class getKeyType(String key) {
        return this.primaryKeyDbTypeByName.get(key);
    }

    public void addClassPrimaryKey(String key, Class type) {
        this.primaryKeyClassTypeByName.put(key, type);
    }

    public Class getClassKeyType(String key) {
        return this.primaryKeyClassTypeByName.get(key);
    }

    public static String getTableName(Class tableClass) {
        return ConfigManager.getInstance().getTableName(tableClass);
    }

    public List<RelationInfo> getRelationInfos() {
        return this.relationInfoListFoundInClass;
    }

    public List<RelationInfo> getRelationInfos(Class relationType) {
        return this.relationInfoListFoundInClass.stream().filter(r -> r.getRelation().annotationType() == relationType).collect(Collectors.toList());
    }
}

