/*
 * Decompiled with CFR 0.152.
 */
package safayat.orm.query;

import java.sql.ResultSet;
import java.util.List;
import safayat.orm.annotation.ManyToMany;
import safayat.orm.annotation.ManyToOne;
import safayat.orm.annotation.OneToMany;
import safayat.orm.dao.GeneralRepositoryManager;
import safayat.orm.jdbcUtility.TableMetadata;
import safayat.orm.query.MysqlCondition;
import safayat.orm.query.MysqlTable;
import safayat.orm.query.QueryInfo;
import safayat.orm.reflect.ReflectUtility;
import safayat.orm.reflect.RelationInfo;

public class MysqlQuery {
    private QueryInfo query = new QueryInfo();

    public MysqlQuery(String fields) {
        this.query.appendFields(fields);
    }

    public static MysqlQuery fields(String fields) {
        return new MysqlQuery(fields);
    }

    public static MysqlQuery All() {
        return new MysqlQuery("*");
    }

    public static <I> I load(Class<I> clazz, Object primaryOrUniqueKey) {
        return GeneralRepositoryManager.getInstance().getGeneralRepository().get(clazz, primaryOrUniqueKey);
    }

    public static <T> List<T> getAll(Class<T> clazz, int limit) {
        return GeneralRepositoryManager.getInstance().getGeneralRepository().getAll(clazz, limit);
    }

    public static <T> List<T> getAll(Class<T> clazz, int limit, int offset) {
        return GeneralRepositoryManager.getInstance().getGeneralRepository().getAll(clazz, limit, offset);
    }

    public static ResultSet execute(String sql) {
        return GeneralRepositoryManager.getInstance().getGeneralRepository().executeQuery(sql).getResultSet();
    }

    public String toString() {
        return this.query.toString();
    }

    public MysqlTable table(String tableName, String alias) {
        this.query.append("select " + this.query.getQueryFields().toString() + " from ");
        return new MysqlTable(this.query).table(tableName, alias);
    }

    public MysqlTable table(String tableName) {
        this.query.append("select " + this.query.getQueryFields().toString() + " from ");
        String[] splitted = tableName.trim().split(" ");
        String code = "";
        if (splitted.length > 1) {
            code = splitted[1];
            return new MysqlTable(this.query).table(splitted[0], code);
        }
        return new MysqlTable(this.query).table(tableName, "");
    }

    public MysqlTable table(Class tableClass, String alias) {
        return this.table(TableMetadata.getTableName(tableClass), alias);
    }

    public MysqlCondition oneToMany(Class parent, Class child) throws Exception {
        RelationInfo oneToMany = ReflectUtility.getRelationAnnotation(parent, OneToMany.class, child);
        if (oneToMany == null) {
            throw new Exception("One to many Relation not found!");
        }
        this.query.setTableBegan(true);
        this.query.append("select " + this.query.getQueryFields().toString() + " from ").append(oneToMany.createJoinSql());
        return new MysqlCondition(this.query, false);
    }

    public MysqlCondition manyToOne(Class parent, Class child) throws Exception {
        RelationInfo manyToOne = ReflectUtility.getRelationAnnotation(parent, ManyToOne.class, child);
        if (manyToOne == null) {
            throw new Exception("Many to many Relation not found!");
        }
        this.query.setTableBegan(true);
        this.query.append("select " + this.query.getQueryFields().toString() + " from ").append(manyToOne.createJoinSql());
        return new MysqlCondition(this.query, false);
    }

    public MysqlCondition manyToMany(Class parent, Class child) throws Exception {
        RelationInfo manyToMany = ReflectUtility.getRelationAnnotation(parent, ManyToMany.class, child);
        if (manyToMany == null) {
            throw new Exception("Many to many Relation not found!");
        }
        this.query.setTableBegan(true);
        this.query.append("select " + this.query.getQueryFields().toString() + " from ").append(manyToMany.getTableName()).append(" ").append(manyToMany.getTableName().toLowerCase()).append(manyToMany.createManyToManyJoinSql());
        return new MysqlCondition(this.query, false);
    }

    public MysqlTable table(Class tableClass) {
        return this.table(TableMetadata.getTableName(tableClass));
    }
}

