/*
 * Decompiled with CFR 0.152.
 */
package safayat.orm.query;

import safayat.orm.interfaces.ConditionInterface;
import safayat.orm.interfaces.GroupByInterface;
import safayat.orm.interfaces.LimitInterface;
import safayat.orm.interfaces.OrderInterface;
import safayat.orm.jdbcUtility.TableMetadata;
import safayat.orm.query.MysqlJoin;
import safayat.orm.query.QueryDataConverter;
import safayat.orm.query.QueryInfo;

public class MysqlTable
extends QueryDataConverter
implements ConditionInterface,
OrderInterface,
GroupByInterface,
LimitInterface {
    private MysqlJoin mysqlJoin = new MysqlJoin(this);
    public static String JOIN = "join";
    public static String LEFT_JOIN = "left join";
    public static String RIGHT_JOIN = "right join";

    public MysqlTable(QueryInfo query) {
        super(query);
    }

    public MysqlTable table(String tableName, String code) {
        if (this.query.isTableBegan()) {
            this.query.append(",");
        }
        this.query.setTableBegan(true);
        this.query.append(tableName).append(" ").append(code);
        return this;
    }

    public MysqlTable table(String tableName) {
        if (this.query.isTableBegan()) {
            this.query.append(",");
        }
        this.query.setTableBegan(true);
        this.createAndAppendJoinSqlString(tableName, "");
        return this;
    }

    private void createAndAppendJoinSqlString(String tableName, String joinName) {
        String[] splitted = tableName.split(" ");
        tableName = splitted[0];
        String code = splitted.length > 1 ? splitted[1] : "";
        this.query.append(" ").append(joinName).append(" ").append(tableName).append(" ").append(code);
    }

    private void createAndAppendJoinSqlString(String tableName, String code, String joinName) {
        this.query.append(" ").append(joinName).append(" ").append(tableName).append(" ").append(code);
    }

    public MysqlJoin join(String tableName, String code) {
        this.createAndAppendJoinSqlString(tableName, code, JOIN);
        return this.mysqlJoin;
    }

    public MysqlJoin leftJoin(String tableName, String code) {
        this.createAndAppendJoinSqlString(tableName, code, LEFT_JOIN);
        return this.mysqlJoin;
    }

    public MysqlJoin rightJoin(String tableName, String code) {
        this.createAndAppendJoinSqlString(tableName, code, RIGHT_JOIN);
        return this.mysqlJoin;
    }

    public MysqlJoin rightJoin(String tableName) {
        this.createAndAppendJoinSqlString(tableName, RIGHT_JOIN);
        return this.mysqlJoin;
    }

    public MysqlJoin join(String tableName) {
        this.createAndAppendJoinSqlString(tableName, JOIN);
        return this.mysqlJoin;
    }

    public MysqlJoin leftJoin(String tableName) {
        this.createAndAppendJoinSqlString(tableName, LEFT_JOIN);
        return this.mysqlJoin;
    }

    public MysqlJoin join(Class tableName, String code) {
        this.createAndAppendJoinSqlString(TableMetadata.getTableName(tableName), code, JOIN);
        return this.mysqlJoin;
    }

    public MysqlJoin leftJoin(Class tableName, String code) {
        this.createAndAppendJoinSqlString(TableMetadata.getTableName(tableName), code, LEFT_JOIN);
        return this.mysqlJoin;
    }

    public MysqlJoin rightJoin(Class tableName, String code) {
        this.createAndAppendJoinSqlString(TableMetadata.getTableName(tableName), code, RIGHT_JOIN);
        return this.mysqlJoin;
    }

    public MysqlJoin rightJoin(Class tableName) {
        this.createAndAppendJoinSqlString(TableMetadata.getTableName(tableName), RIGHT_JOIN);
        return this.mysqlJoin;
    }

    public MysqlJoin join(Class tableName) {
        this.createAndAppendJoinSqlString(TableMetadata.getTableName(tableName), JOIN);
        return this.mysqlJoin;
    }

    public MysqlJoin leftJoin(Class tableName) {
        this.createAndAppendJoinSqlString(TableMetadata.getTableName(tableName), LEFT_JOIN);
        return this.mysqlJoin;
    }
}

