/*
 * Decompiled with CFR 0.152.
 */
package safayat.orm.reflect;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class FileManager {
    public static void write(String filePath, String fileString) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(filePath));
            writer.write(fileString);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Class[] getClasses(String packageNamesAsString) throws ClassNotFoundException, IOException {
        String[] packageNames;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        ArrayList classes = new ArrayList();
        for (String packageName : packageNames = packageNamesAsString.split(",")) {
            String path = packageName.replace('.', '/');
            Enumeration<URL> resources = classLoader.getResources(path);
            ArrayList<File> dirs = new ArrayList<File>();
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                dirs.add(new File(URLDecoder.decode(resource.getFile(), "UTF-8")));
            }
            for (File directory : dirs) {
                classes.addAll(FileManager.findClasses(directory, packageName));
            }
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static List findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(FileManager.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }
}

