/*
 * Decompiled with CFR 0.152.
 */
package safayat.orm.reflect;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import safayat.orm.config.ConfigManager;
import safayat.orm.jdbcUtility.TableMetadata;
import safayat.orm.reflect.RelationInfo;

public class RelationGraph {
    private Class classTreeNode;
    private Map<String, Class> visitedMap = new HashMap<String, Class>();
    private Map<Class, RelationInfo> relationInfoByParentClass = new HashMap<Class, RelationInfo>();

    public RelationGraph(Class classTreeNode) throws Exception {
        this.classTreeNode = classTreeNode;
        this.visitedMap = new HashMap<String, Class>();
        this.relationInfoByParentClass = new HashMap<Class, RelationInfo>();
        this.populateRelationDataStructures(classTreeNode);
    }

    private void populateRelationDataStructures(Class node) throws Exception {
        this.addToVisitedMap(node);
        List<RelationInfo> annotationList = ConfigManager.getInstance().getTableMetadata(node).getRelationInfos();
        for (RelationInfo relationInfo : annotationList) {
            Class child = relationInfo.getFieldType();
            if (child == null || !this.notVisited(child)) continue;
            this.addNewRelation(relationInfo);
            this.populateRelationDataStructures(child);
        }
    }

    private void addNewRelation(RelationInfo relationInfo) {
        this.relationInfoByParentClass.put(relationInfo.getFieldType(), relationInfo);
    }

    private void addToVisitedMap(Class node) {
        this.visitedMap.put(TableMetadata.getTableName(node).toLowerCase(), node);
    }

    private boolean isVisited(Class node) {
        return this.visitedMap.containsKey(TableMetadata.getTableName(node).toLowerCase());
    }

    private boolean notVisited(Class node) {
        return !this.isVisited(node);
    }

    public RelationInfo getRelationInfo(Class parent) {
        return this.relationInfoByParentClass.get(parent);
    }
}

