/*
 * Decompiled with CFR 0.152.
 */
package safayat.orm.reflect;

import java.lang.annotation.Annotation;
import safayat.orm.annotation.ManyToMany;
import safayat.orm.annotation.ManyToOne;
import safayat.orm.annotation.OneToMany;
import safayat.orm.jdbcUtility.TableMetadata;
import safayat.orm.reflect.Util;

public class RelationInfo {
    private Annotation relation;
    private Class parent;

    public RelationInfo(Annotation relation, Class parent) {
        this.relation = relation;
        this.parent = parent;
    }

    public boolean isRelationAnnotation() {
        return this.isManyToOne() || this.isOneToMany() || this.isManyToMany();
    }

    public boolean isOneToMany() {
        return this.relation instanceof OneToMany;
    }

    public boolean isManyToMany() {
        return this.relation instanceof ManyToMany;
    }

    public boolean isManyToOne() {
        return this.relation instanceof ManyToOne;
    }

    public String typeAsString() {
        return this.relation.annotationType().getName();
    }

    public Annotation getRelation() {
        return this.relation;
    }

    public String getNativeColumn() {
        if (this.isOneToMany()) {
            return ((OneToMany)this.relation).nativeColumnName();
        }
        if (this.isManyToMany()) {
            return ((ManyToMany)this.relation).nativeColumnName();
        }
        return ((ManyToOne)this.relation).nativeColumnName();
    }

    public String getMatchingColumn() {
        if (this.isOneToMany()) {
            return ((OneToMany)this.relation).matchingColumnName();
        }
        if (this.isManyToMany()) {
            return ((ManyToMany)this.relation).matchingColumnName();
        }
        return ((ManyToOne)this.relation).matchingColumnName();
    }

    public String getNativeColumnWithDefaultAlias() {
        return this.getTableName().toLowerCase() + "." + this.getNativeColumn();
    }

    public String getMatchingColumnWithDefaultAlias() {
        return this.getChildTableName().toLowerCase() + "." + this.getMatchingColumn();
    }

    public String getFieldName() {
        if (this.isOneToMany()) {
            return ((OneToMany)this.relation).name();
        }
        if (this.isManyToMany()) {
            return ((ManyToMany)this.relation).name();
        }
        return ((ManyToOne)this.relation).name();
    }

    public String getNativeRelationColumn() {
        return this.isManyToMany() ? ((ManyToMany)this.relation).nativeRelationColumnName() : null;
    }

    public String getMatchingRelationColumn() {
        return this.isManyToMany() ? ((ManyToMany)this.relation).matchingRelationColumnName() : null;
    }

    public String getNativeRelationColumnWithDefaultAlias() {
        return this.getRelationTable().toLowerCase() + "." + this.getNativeRelationColumn();
    }

    public String getMatchingRelationColumnWithDefaultAlias() {
        return this.getRelationTable().toLowerCase() + "." + this.getMatchingRelationColumn();
    }

    public String getRelationTable() {
        return this.isManyToMany() ? ((ManyToMany)this.relation).relationTable() : null;
    }

    public Class getFieldType() {
        if (this.isOneToMany()) {
            return ((OneToMany)this.relation).type();
        }
        if (this.isManyToMany()) {
            return ((ManyToMany)this.relation).type();
        }
        return ((ManyToOne)this.relation).type();
    }

    public boolean haveRelationInfo() {
        if (Util.isEmpty(this.getNativeColumn()) || Util.isEmpty(this.getMatchingColumn())) {
            return false;
        }
        return !this.isManyToMany() || !Util.isEmpty(this.getNativeRelationColumn()) && !Util.isEmpty(this.getMatchingRelationColumn());
    }

    public boolean doNotHaveRelationInfo() {
        return !this.haveRelationInfo();
    }

    public String getTableName() {
        return TableMetadata.getTableName(this.parent);
    }

    public String getChildTableName() {
        return TableMetadata.getTableName(this.getFieldType());
    }

    public String createManyToManyJoinSql() throws Exception {
        if (this.doNotHaveRelationInfo()) {
            throw new Exception("Not enough relation info");
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" join ").append(this.getRelationTable()).append(" ").append(this.getRelationTable().toLowerCase()).append(" on ").append(this.getNativeColumnWithDefaultAlias()).append("=").append(this.getNativeRelationColumnWithDefaultAlias()).append(" join ").append(this.getChildTableName()).append(" ").append(this.getChildTableName().toLowerCase()).append(" on ").append(this.getMatchingRelationColumnWithDefaultAlias()).append("=").append(this.getMatchingColumnWithDefaultAlias());
        return sql.toString();
    }

    public String createJoinSql() throws Exception {
        return " " + this.getTableName() + " " + this.getTableName().toLowerCase() + " join " + this.getChildTableName() + " " + this.getChildTableName().toLowerCase() + " on " + this.getNativeColumnWithDefaultAlias() + " = " + this.getMatchingColumnWithDefaultAlias();
    }

    public Class getParent() {
        return this.parent;
    }
}

