/*
 * Decompiled with CFR 0.152.
 */
package safayat.orm.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Time;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Util {
    public static DateFormat mysqlDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String toCamelCase(String str) {
        StringBuilder stringBuilder = new StringBuilder(str);
        char ch = str.charAt(0);
        if (ch >= 'a') {
            stringBuilder.setCharAt(0, (char)(str.charAt(0) & 0x5F));
        }
        return stringBuilder.toString();
    }

    public static String classNameToTable(String str) {
        return String.valueOf(str.charAt(0)).toLowerCase() + str.substring(1);
    }

    public static String mysqlFieldtoJavaVariableName(String str) {
        String[] splitted = str.split("[_]+");
        StringBuilder stringBuilder = new StringBuilder(splitted[0]);
        for (int i = 1; i < splitted.length; ++i) {
            stringBuilder.append(Util.toCamelCase(splitted[1]));
        }
        return stringBuilder.toString();
    }

    public static String mysqlTabletoJavaClassName(String str) {
        String camelCaseName = Util.mysqlFieldtoJavaVariableName(str);
        return camelCaseName.substring(0, 1).toUpperCase() + camelCaseName.substring(1);
    }

    public static String toJavaMethodName(String variableName, String prefix) {
        return prefix + Util.toTitle(variableName);
    }

    public static List<Annotation> getMethodAnnotations(Class clazz) {
        Method[] methods;
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        for (Method m : methods = clazz.getDeclaredMethods()) {
            for (Annotation annotation : m.getDeclaredAnnotations()) {
                list.add(annotation);
            }
        }
        return list;
    }

    public static List<Annotation> getFieldAnnotations(Class clazz) {
        Field[] fields;
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        for (Field f : fields = clazz.getDeclaredFields()) {
            for (Annotation annotation : f.getDeclaredAnnotations()) {
                list.add(annotation);
            }
        }
        return list;
    }

    public static List<Annotation> getFieldAnnotations(Class clazz, Class type) {
        Field[] fields;
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        for (Field f : fields = clazz.getDeclaredFields()) {
            for (Annotation annotation : f.getDeclaredAnnotationsByType(type)) {
                list.add(annotation);
            }
        }
        return list;
    }

    public static Class getClassByMysqlType(int type) {
        if (-5 == type) {
            return Long.class;
        }
        if (-2 == type) {
            return Boolean.class;
        }
        if (4 == type) {
            return Integer.class;
        }
        if (91 == type) {
            return Date.class;
        }
        if (93 == type) {
            return Date.class;
        }
        if (92 == type) {
            return Time.class;
        }
        if (2004 == type) {
            return Blob.class;
        }
        if (6 == type) {
            return Float.class;
        }
        if (8 == type) {
            return Double.class;
        }
        if (2003 == type) {
            return Array.class;
        }
        return String.class;
    }

    public static Class getFieldClass(Class clazz, String name) throws NoSuchFieldException {
        return clazz.getDeclaredField(name).getType();
    }

    public static Object castToSpecificType(Class type, String value) {
        if (type.getSimpleName().equalsIgnoreCase("int") || type.getSimpleName().equalsIgnoreCase(Integer.class.getSimpleName())) {
            return Integer.parseInt(value);
        }
        if (type.getSimpleName().equalsIgnoreCase("long") || type.getSimpleName().equalsIgnoreCase(Long.class.getSimpleName())) {
            return Long.parseLong(value);
        }
        if (type.getSimpleName().equalsIgnoreCase("float") || type.getSimpleName().equalsIgnoreCase(Float.class.getSimpleName())) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type.getSimpleName().equalsIgnoreCase("double") || type.getSimpleName().equalsIgnoreCase(Double.class.getSimpleName())) {
            return Double.parseDouble(value);
        }
        if (type.getSimpleName().equalsIgnoreCase("byte") || type.getSimpleName().equalsIgnoreCase(Byte.class.getSimpleName())) {
            return Byte.parseByte(value);
        }
        return null;
    }

    public static String methodToVariableName(String methodName) {
        int from = 0;
        if (methodName.startsWith("get")) {
            from = 3;
        }
        return String.valueOf(methodName.charAt(from)).toLowerCase() + methodName.substring(from + 1);
    }

    public static String listAsString(List list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            stringBuilder.append(list.get(i));
            if (i >= list.size() - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public static String toQuote(String str) {
        return "\"" + str + "\"";
    }

    public static String toMysqlString(Object ob) {
        if (ob instanceof Date) {
            return Util.toQuote(mysqlDateFormat.format((Date)ob));
        }
        if (ob == null) {
            return "NULL";
        }
        return Util.toQuote(ob.toString());
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static char upper(char c) {
        return c >= 'a' && c <= 'z' ? (char)(c - 32) : c;
    }

    public static char lower(char c) {
        return c >= 'A' && c <= 'Z' ? (char)(c + 32) : c;
    }

    public static String tableName(Class clazz) {
        char[] chars = clazz.getSimpleName().toCharArray();
        chars[0] = Util.lower(chars[0]);
        return new String(chars);
    }

    public static String toTitle(String str) {
        char[] chars = str.toCharArray();
        chars[0] = Util.upper(chars[0]);
        return new String(chars);
    }

    public static void removeLastCharacter(StringBuilder stringBuilder) {
        if (stringBuilder.length() > 0) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
    }

    public static void rightStripIfExists(StringBuilder stringBuilder, char suffix) {
        if (stringBuilder.charAt(stringBuilder.length() - 1) == suffix) {
            Util.removeLastCharacter(stringBuilder);
        }
    }
}

