/*
 * Decompiled with CFR 0.152.
 */
package cn.jiguang.sdk.api;

import cn.jiguang.sdk.bean.push.GroupPushSendParam;
import cn.jiguang.sdk.bean.push.GroupPushSendResult;
import cn.jiguang.sdk.client.GroupPushClient;
import cn.jiguang.sdk.codec.ApiDecoder;
import cn.jiguang.sdk.codec.ApiEncoder;
import cn.jiguang.sdk.codec.ApiErrorDecoder;
import feign.Client;
import feign.Feign;
import feign.Logger;
import feign.RequestInterceptor;
import feign.auth.BasicAuthRequestInterceptor;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.slf4j.Slf4jLogger;
import java.net.Proxy;
import lombok.NonNull;
import okhttp3.OkHttpClient;

public class GroupPushApi {
    private final GroupPushClient groupPushClient;

    protected GroupPushApi(@NonNull GroupPushClient groupPushClient) {
        if (groupPushClient == null) {
            throw new NullPointerException("groupPushClient is marked non-null but is null");
        }
        this.groupPushClient = groupPushClient;
    }

    public GroupPushSendResult send(@NonNull GroupPushSendParam param) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        return this.groupPushClient.send(param);
    }

    public static class Builder {
        private String host = "https://api.jpush.cn";
        private Proxy proxy;
        private String groupKey;
        private String groupMasterSecret;
        private Logger.Level loggerLevel = Logger.Level.BASIC;

        public Builder setHost(@NonNull String host) {
            if (host == null) {
                throw new NullPointerException("host is marked non-null but is null");
            }
            this.host = host;
            return this;
        }

        public Builder setProxy(@NonNull Proxy proxy) {
            if (proxy == null) {
                throw new NullPointerException("proxy is marked non-null but is null");
            }
            this.proxy = proxy;
            return this;
        }

        public Builder setGroupKey(@NonNull String groupKey) {
            if (groupKey == null) {
                throw new NullPointerException("groupKey is marked non-null but is null");
            }
            this.groupKey = groupKey;
            return this;
        }

        public Builder setGroupMasterSecret(@NonNull String groupMasterSecret) {
            if (groupMasterSecret == null) {
                throw new NullPointerException("groupMasterSecret is marked non-null but is null");
            }
            this.groupMasterSecret = groupMasterSecret;
            return this;
        }

        public Builder setLoggerLevel(@NonNull Logger.Level loggerLevel) {
            if (loggerLevel == null) {
                throw new NullPointerException("loggerLevel is marked non-null but is null");
            }
            this.loggerLevel = loggerLevel;
            return this;
        }

        public GroupPushApi build() {
            OkHttpClient.Builder delegateBuilder = new OkHttpClient().newBuilder();
            if (this.proxy != null) {
                delegateBuilder.proxy(this.proxy);
            }
            GroupPushClient groupPushClient = (GroupPushClient)Feign.builder().client((Client)new feign.okhttp.OkHttpClient(delegateBuilder.build())).requestInterceptor((RequestInterceptor)new BasicAuthRequestInterceptor("group-" + this.groupKey, this.groupMasterSecret)).encoder((Encoder)new ApiEncoder()).decoder((Decoder)new ApiDecoder()).errorDecoder((ErrorDecoder)new ApiErrorDecoder()).logger((Logger)new Slf4jLogger()).logLevel(this.loggerLevel).target(GroupPushClient.class, this.host);
            return new GroupPushApi(groupPushClient);
        }
    }
}

