/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.processor;

import io.github.linpeilie.processor.utils.FileUtils;
import io.github.linpeilie.utils.CollectionUtils;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class BuildCollator {
    private final ProcessingEnvironment processingEnv;
    private final File collatorFile;
    private List<TypeElement> records;

    public BuildCollator(ProcessingEnvironment processingEnv, String fileName) {
        this.processingEnv = processingEnv;
        Filer filer = processingEnv.getFiler();
        try {
            FileObject fileObject = filer.getResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/mps/" + fileName);
            this.collatorFile = new File(fileObject.getName());
            this.records = this.collatorFile.exists() ? FileUtils.readUtf8Lines(this.collatorFile).stream().map(line -> processingEnv.getElementUtils().getTypeElement((CharSequence)line)).filter(Objects::nonNull).collect(Collectors.toList()) : new ArrayList<TypeElement>();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void writeTypeElements(Collection<TypeElement> typeElements) {
        Set<String> names = typeElements.stream().map(typeElement -> typeElement.getQualifiedName().toString()).collect(Collectors.toSet());
        this.write(names);
    }

    private void write(Collection<String> lines) {
        if (CollectionUtils.isEmpty(lines)) {
            return;
        }
        this.records = lines.stream().map(line -> this.processingEnv.getElementUtils().getTypeElement((CharSequence)line)).filter(Objects::nonNull).collect(Collectors.toList());
        FileUtils.mkParentDirs(this.collatorFile);
        FileUtils.writeUtf8Lines(lines, this.collatorFile);
    }

    private List<String> loadRecords() {
        return this.records.stream().map(ele -> ele.getQualifiedName().toString()).collect(Collectors.toList());
    }

    public List<TypeElement> getRecords() {
        return this.records;
    }

    public void consumeRecords(Consumer<TypeElement> consumer) {
        List<TypeElement> typeElements = this.getRecords();
        if (CollectionUtils.isNotEmpty(typeElements)) {
            typeElements.forEach(consumer);
        }
    }

    public void appendNonexistent(Collection<? extends Element> newRecords) {
        List<String> lines = this.loadRecords();
        newRecords.forEach(ele -> {
            String classQualifiedName = ((TypeElement)ele).getQualifiedName().toString();
            lines.add(classQualifiedName);
        });
        this.write(new HashSet<String>(lines));
    }
}

