/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.processor.generator;

import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.github.linpeilie.processor.metadata.AutoEnumMapperMetadata;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import javax.lang.model.element.Modifier;

public class AutoEnumMapperGenerator {
    public void write(AutoEnumMapperMetadata metadata, Writer writer) {
        try {
            JavaFile.builder((String)metadata.mapperPackage(), (TypeSpec)this.createTypeSpec(metadata)).build().writeTo((Appendable)writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private TypeSpec createTypeSpec(AutoEnumMapperMetadata metadata) {
        return TypeSpec.classBuilder((String)metadata.mapperName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(this.buildToEnumMethod(metadata)).addMethod(this.buildToValueMethod(metadata)).build();
    }

    private MethodSpec buildToValueMethod(AutoEnumMapperMetadata metadata) {
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.add("if(e == null) { ", new Object[0]);
        if (metadata.getReturnType().isPrimitive()) {
            String returnType;
            switch (returnType = metadata.getReturnType().toString()) {
                case "char": {
                    builder.add("return '\u0000';", new Object[0]);
                    break;
                }
                case "boolean": {
                    builder.add("return false;", new Object[0]);
                    break;
                }
                default: {
                    builder.add("return 0;", new Object[0]);
                    break;
                }
            }
        } else {
            builder.add("return null;", new Object[0]);
        }
        builder.add("}", new Object[0]);
        builder.add("return e." + metadata.getGetter() + "();", new Object[0]);
        return MethodSpec.methodBuilder((String)metadata.toValueMethodName()).addParameter(ParameterSpec.builder((TypeName)metadata.getSourceClassName(), (String)"e", (Modifier[])new Modifier[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addCode(builder.build()).returns(metadata.getReturnType()).build();
    }

    private MethodSpec buildToEnumMethod(AutoEnumMapperMetadata metadata) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)metadata.toEnumMethodName()).addParameter(ParameterSpec.builder((TypeName)metadata.getReturnType(), (String)"value", (Modifier[])new Modifier[0]).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        if (!metadata.getReturnType().isPrimitive()) {
            builder.addCode(CodeBlock.builder().add("if(value == null) { return null; }", new Object[0]).build());
        }
        return builder.addCode(CodeBlock.builder().add("$T[] enums = $T.values();", new Object[]{metadata.getSourceClassName(), metadata.getSourceClassName()}).build()).addCode(CodeBlock.builder().add("for($T e : enums) {", new Object[]{metadata.getSourceClassName()}).build()).addCode(CodeBlock.builder().add("if(String.valueOf(e.$L()).contentEquals(String.valueOf(value))) { return e; }", new Object[]{metadata.getGetter()}).build()).addCode("} return null;", new Object[0]).returns((TypeName)metadata.getSourceClassName()).build();
    }
}

