/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.common.util;

import com.dtp.common.constant.DynamicTpConst;

public final class ThreadPoolUtil {
    private static final double DEFAULT_BLOCK_COEFFICIENT = 0.9;

    private ThreadPoolUtil() {
    }

    public static int getCpuIntensivePoolSize() {
        return ThreadPoolUtil.getIoIntensivePoolSize(0.0);
    }

    public static int getIoIntensivePoolSize() {
        return ThreadPoolUtil.getIoIntensivePoolSize(0.9);
    }

    public static int getIoIntensivePoolSize(double blockingCoefficient) {
        return ThreadPoolUtil.poolSize(blockingCoefficient);
    }

    public static int poolSize(double blockingCoefficient) {
        return (int)((double)DynamicTpConst.AVAILABLE_PROCESSORS / (1.0 - blockingCoefficient));
    }
}

