/*
 * Decompiled with CFR 0.152.
 */
package com.dtp.logging;

import com.dtp.logging.DtpLogging;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.cloud.bootstrap.BootstrapImportSelectorConfiguration;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.ResolvableType;

public class DtpLoggingListener
implements GenericApplicationListener {
    private static final Logger log = LoggerFactory.getLogger(DtpLoggingListener.class);

    public boolean supportsEventType(ResolvableType resolvableType) {
        Class type = resolvableType.getRawClass();
        if (type != null) {
            return ApplicationStartedEvent.class.isAssignableFrom(type);
        }
        return false;
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        try {
            SpringApplication application;
            Set sources;
            Class.forName("org.springframework.cloud.bootstrap.BootstrapImportSelectorConfiguration");
            Class<?> type = applicationEvent.getSource().getClass();
            if (SpringApplication.class.isAssignableFrom(type) && (sources = (application = (SpringApplication)applicationEvent.getSource()).getAllSources()).size() == 1 && sources.contains(BootstrapImportSelectorConfiguration.class)) {
                return;
            }
        }
        catch (ClassNotFoundException e) {
            log.warn("DynamicTp logging init, not spring cloud application.");
        }
        DtpLogging.getInstance().loadConfiguration();
    }

    public int getOrder() {
        return -2147483624;
    }
}

