/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.cache;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.alibaba.nacos.client.utils.ConcurrentDiskUtil;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DiskCache {
    public static void write(ServiceInfo dom, String dir) {
        try {
            DiskCache.makeSureCacheDirExists(dir);
            File file = new File(dir, dom.getKeyEncoded());
            DiskCache.createFileIfAbsent(file, false);
            StringBuilder keyContentBuffer = new StringBuilder();
            String json = dom.getJsonFromServer();
            if (StringUtils.isEmpty((String)json)) {
                json = JacksonUtils.toJson((Object)dom);
            }
            keyContentBuffer.append(json);
            ConcurrentDiskUtil.writeFileContent(file, keyContentBuffer.toString(), Charset.defaultCharset().toString());
        }
        catch (Throwable e) {
            LogUtils.NAMING_LOGGER.error("[NA] failed to write cache for dom:" + dom.getName(), e);
        }
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static Map<String, ServiceInfo> read(String cacheDir) {
        HashMap<String, ServiceInfo> domMap = new HashMap<String, ServiceInfo>(16);
        try {
            File[] files = DiskCache.makeSureCacheDirExists(cacheDir).listFiles();
            if (files == null || files.length == 0) {
                return domMap;
            }
            for (File file : files) {
                if (!file.isFile()) continue;
                domMap.putAll(DiskCache.parseServiceInfoFromCache(file));
            }
        }
        catch (Throwable e) {
            LogUtils.NAMING_LOGGER.error("[NA] failed to read cache file", e);
        }
        return domMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, ServiceInfo> parseServiceInfoFromCache(File file) throws UnsupportedEncodingException {
        HashMap<String, ServiceInfo> result = new HashMap<String, ServiceInfo>(1);
        String fileName = URLDecoder.decode(file.getName(), "UTF-8");
        if (fileName.endsWith("@@meta")) return result;
        if (fileName.endsWith("@@special-url")) return result;
        ServiceInfo dom = new ServiceInfo(fileName);
        ArrayList<Instance> ips = new ArrayList<Instance>();
        dom.setHosts(ips);
        ServiceInfo newFormat = null;
        try (BufferedReader reader = new BufferedReader(new StringReader(ConcurrentDiskUtil.getFileContent(file, Charset.defaultCharset().toString())));){
            String json;
            while ((json = reader.readLine()) != null) {
                try {
                    if (!json.startsWith("{") || !StringUtils.isEmpty((String)(newFormat = (ServiceInfo)JacksonUtils.toObj((String)json, ServiceInfo.class)).getName())) continue;
                    ips.add((Instance)JacksonUtils.toObj((String)json, Instance.class));
                }
                catch (Throwable e) {
                    LogUtils.NAMING_LOGGER.error("[NA] error while parsing cache file: " + json, e);
                }
            }
        }
        catch (Exception e) {
            LogUtils.NAMING_LOGGER.error("[NA] failed to read cache for dom: " + file.getName(), (Throwable)e);
        }
        if (newFormat != null && !StringUtils.isEmpty((String)newFormat.getName()) && !CollectionUtils.isEmpty(newFormat.getHosts())) {
            result.put(dom.getKey(), newFormat);
            return result;
        }
        if (CollectionUtils.isEmpty(dom.getHosts())) return result;
        result.put(dom.getKey(), dom);
        return result;
    }

    public static void createFileIfAbsent(File file, boolean isDir) throws IOException {
        boolean createResult;
        if (file.exists()) {
            return;
        }
        boolean bl = createResult = isDir ? file.mkdirs() : file.createNewFile();
        if (!createResult && !file.exists()) {
            throw new IllegalStateException("failed to create cache : " + (isDir ? "dir" : file) + file.getPath());
        }
    }

    private static File makeSureCacheDirExists(String dir) throws IOException {
        File cacheDir = new File(dir);
        DiskCache.createFileIfAbsent(cacheDir, true);
        return cacheDir;
    }
}

