/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.utils;

import com.alibaba.nacos.client.utils.LogUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;

public class EnvUtil {
    public static final Logger LOGGER = LogUtils.logger(EnvUtil.class);
    private static String selfAmoryTag;
    private static String selfVipserverTag;
    private static String selfLocationTag;

    public static void setSelfEnv(Map<String, List<String>> headers) {
        if (headers != null) {
            List<String> locationTagTmp;
            List<String> vipserverTagTmp;
            List<String> amoryTagTmp = headers.get("Amory-Tag");
            if (amoryTagTmp == null) {
                if (selfAmoryTag != null) {
                    selfAmoryTag = null;
                    LOGGER.warn("selfAmoryTag:null");
                }
            } else {
                String amoryTagTmpStr = EnvUtil.listToString(amoryTagTmp);
                if (!Objects.equals(amoryTagTmpStr, selfAmoryTag)) {
                    selfAmoryTag = amoryTagTmpStr;
                    LOGGER.warn("selfAmoryTag:{}", (Object)selfAmoryTag);
                }
            }
            if ((vipserverTagTmp = headers.get("Vipserver-Tag")) == null) {
                if (selfVipserverTag != null) {
                    selfVipserverTag = null;
                    LOGGER.warn("selfVipserverTag:null");
                }
            } else {
                String vipserverTagTmpStr = EnvUtil.listToString(vipserverTagTmp);
                if (!Objects.equals(vipserverTagTmpStr, selfVipserverTag)) {
                    selfVipserverTag = vipserverTagTmpStr;
                    LOGGER.warn("selfVipserverTag:{}", (Object)selfVipserverTag);
                }
            }
            if ((locationTagTmp = headers.get("Location-Tag")) == null) {
                if (selfLocationTag != null) {
                    selfLocationTag = null;
                    LOGGER.warn("selfLocationTag:null");
                }
            } else {
                String locationTagTmpStr = EnvUtil.listToString(locationTagTmp);
                if (!Objects.equals(locationTagTmpStr, selfLocationTag)) {
                    selfLocationTag = locationTagTmpStr;
                    LOGGER.warn("selfLocationTag:{}", (Object)selfLocationTag);
                }
            }
        }
    }

    public static String getSelfAmoryTag() {
        return selfAmoryTag;
    }

    public static String getSelfVipserverTag() {
        return selfVipserverTag;
    }

    public static String getSelfLocationTag() {
        return selfLocationTag;
    }

    private static String listToString(List<String> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (String string : list) {
            result.append(string);
            result.append(',');
        }
        return result.substring(0, result.length() - 1);
    }
}

