/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.pathencoder.impl;

import com.alibaba.nacos.common.pathencoder.PathEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class WindowsEncoder
implements PathEncoder {
    private static final String PATTERN_EXP = "[^/:*?\"<>|\\\\]+";
    private static final Map<String, String> REG_MAPPING = new HashMap<String, String>();
    private static final Map<String, String> CHAR_MAPPING = new HashMap<String, String>();
    private static final Pattern PATTERN = Pattern.compile("[^/:*?\"<>|\\\\]+");

    @Override
    public String encode(String str, String charset) {
        for (Map.Entry<String, String> entry : REG_MAPPING.entrySet()) {
            str = str.replaceAll(entry.getKey(), entry.getValue());
        }
        return str;
    }

    @Override
    public String decode(String str, String charset) {
        for (Map.Entry<String, String> entry : CHAR_MAPPING.entrySet()) {
            str = str.replaceAll(entry.getKey(), entry.getValue());
        }
        return str;
    }

    @Override
    public String name() {
        return "window";
    }

    @Override
    public boolean needEncode(String key) {
        if (key == null) {
            return false;
        }
        return !PATTERN.matcher(key).matches();
    }

    static {
        REG_MAPPING.put("\\\\", "%A1%");
        REG_MAPPING.put("/", "%A2%");
        REG_MAPPING.put(":", "%A3%");
        REG_MAPPING.put("\\*", "%A4%");
        REG_MAPPING.put("\\?", "%A5%");
        REG_MAPPING.put("\"", "%A6%");
        REG_MAPPING.put("<", "%A7%");
        REG_MAPPING.put(">", "%A8%");
        REG_MAPPING.put("\\|", "%A9%");
        CHAR_MAPPING.put("%A1%", "\\\\");
        CHAR_MAPPING.put("%A2%", "/");
        CHAR_MAPPING.put("%A3%", ":");
        CHAR_MAPPING.put("%A4%", "*");
        CHAR_MAPPING.put("%A5%", "?");
        CHAR_MAPPING.put("%A6%", "\"");
        CHAR_MAPPING.put("%A7%", "<");
        CHAR_MAPPING.put("%A8%", ">");
        CHAR_MAPPING.put("%A9%", "|");
    }
}

