/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.remote.client;

import com.alibaba.nacos.common.remote.client.RpcClientTlsConfig;
import com.alibaba.nacos.common.remote.client.RpcTlsConfigFactory;
import java.util.Properties;

public class RpcClientTlsConfigFactory
implements RpcTlsConfigFactory {
    private static RpcClientTlsConfigFactory instance;

    private RpcClientTlsConfigFactory() {
    }

    public static synchronized RpcClientTlsConfigFactory getInstance() {
        if (instance == null) {
            instance = new RpcClientTlsConfigFactory();
        }
        return instance;
    }

    @Override
    public RpcClientTlsConfig createSdkConfig(Properties properties) {
        RpcClientTlsConfig tlsConfig = new RpcClientTlsConfig();
        tlsConfig.setEnableTls(this.getBooleanProperty(properties, "nacos.remote.client.rpc.tls.enable", false));
        tlsConfig.setMutualAuthEnable(this.getBooleanProperty(properties, "nacos.remote.client.rpc.tls.mutualAuth", false));
        tlsConfig.setProtocols(properties.getProperty("nacos.remote.client.rpc.tls.protocols"));
        tlsConfig.setCiphers(properties.getProperty("nacos.remote.client.rpc.tls.ciphers"));
        tlsConfig.setTrustCollectionCertFile(properties.getProperty("nacos.remote.client.rpc.tls.trustCollectionChainPath"));
        tlsConfig.setCertChainFile(properties.getProperty("nacos.remote.client.rpc.tls.certChainFile"));
        tlsConfig.setCertPrivateKey(properties.getProperty("nacos.remote.client.rpc.tls.certPrivateKey"));
        tlsConfig.setTrustAll(this.getBooleanProperty(properties, "nacos.remote.client.rpc.tls.trustAll", true));
        tlsConfig.setCertPrivateKeyPassword(properties.getProperty("nacos.remote.client.rpc.tls.certPrivateKeyPassword"));
        tlsConfig.setSslProvider(properties.getProperty("nacos.remote.client.rpc.tls.provider"));
        return tlsConfig;
    }

    @Override
    public RpcClientTlsConfig createClusterConfig(Properties properties) {
        RpcClientTlsConfig tlsConfig = new RpcClientTlsConfig();
        tlsConfig.setEnableTls(this.getBooleanProperty(properties, "nacos.remote.peer.rpc.tls.enableTls", false));
        tlsConfig.setMutualAuthEnable(this.getBooleanProperty(properties, "nacos.remote.peer.rpc.tls.mutualAuthEnable", false));
        tlsConfig.setProtocols(properties.getProperty("nacos.remote.peer.rpc.tls.protocols"));
        tlsConfig.setCiphers(properties.getProperty("nacos.remote.peer.rpc.tls.ciphers"));
        tlsConfig.setTrustCollectionCertFile(properties.getProperty("nacos.remote.peer.rpc.tls.trustCollectionCertFile"));
        tlsConfig.setCertChainFile(properties.getProperty("nacos.remote.peer.rpc.tls.certChainFile"));
        tlsConfig.setCertPrivateKey(properties.getProperty("nacos.remote.peer.rpc.tls.certPrivateKey"));
        tlsConfig.setTrustAll(this.getBooleanProperty(properties, "nacos.remote.peer.rpc.tls.trustAll", true));
        tlsConfig.setCertPrivateKeyPassword(properties.getProperty("nacos.remote.peer.rpc.tls.certPrivateKeyPassword"));
        tlsConfig.setSslProvider(properties.getProperty("nacos.remote.peer.rpc.tls.sslProvider"));
        return tlsConfig;
    }
}

