/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.dump;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.utils.NetUtils;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.task.NacosTask;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.manager.TaskManager;
import com.alibaba.nacos.config.server.model.ConfigInfoChanged;
import com.alibaba.nacos.config.server.model.event.ConfigDataChangeEvent;
import com.alibaba.nacos.config.server.service.dump.DumpChangeConfigWorker;
import com.alibaba.nacos.config.server.service.dump.DumpRequest;
import com.alibaba.nacos.config.server.service.dump.HistoryConfigCleaner;
import com.alibaba.nacos.config.server.service.dump.HistoryConfigCleanerConfig;
import com.alibaba.nacos.config.server.service.dump.HistoryConfigCleanerManager;
import com.alibaba.nacos.config.server.service.dump.disk.ConfigDiskServiceFactory;
import com.alibaba.nacos.config.server.service.dump.processor.DumpAllBetaProcessor;
import com.alibaba.nacos.config.server.service.dump.processor.DumpAllProcessor;
import com.alibaba.nacos.config.server.service.dump.processor.DumpAllTagProcessor;
import com.alibaba.nacos.config.server.service.dump.processor.DumpProcessor;
import com.alibaba.nacos.config.server.service.dump.task.DumpAllBetaTask;
import com.alibaba.nacos.config.server.service.dump.task.DumpAllTagTask;
import com.alibaba.nacos.config.server.service.dump.task.DumpAllTask;
import com.alibaba.nacos.config.server.service.dump.task.DumpTask;
import com.alibaba.nacos.config.server.service.merge.MergeDatumService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoAggrPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoBetaPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoTagPersistService;
import com.alibaba.nacos.config.server.service.repository.HistoryConfigInfoPersistService;
import com.alibaba.nacos.config.server.utils.ConfigExecutor;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.core.namespace.repository.NamespacePersistService;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.utils.TimerContext;
import java.sql.Timestamp;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DumpService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DumpService.class);
    protected DumpProcessor processor;
    protected DumpAllProcessor dumpAllProcessor;
    protected DumpAllBetaProcessor dumpAllBetaProcessor;
    protected DumpAllTagProcessor dumpAllTagProcessor;
    protected ConfigInfoPersistService configInfoPersistService;
    protected NamespacePersistService namespacePersistService;
    protected HistoryConfigInfoPersistService historyConfigInfoPersistService;
    protected ConfigInfoAggrPersistService configInfoAggrPersistService;
    protected ConfigInfoBetaPersistService configInfoBetaPersistService;
    protected ConfigInfoTagPersistService configInfoTagPersistService;
    protected MergeDatumService mergeDatumService;
    protected final ServerMemberManager memberManager;
    static final int DUMP_ALL_INTERVAL_IN_MINUTE = 360;
    static final int INITIAL_DELAY_IN_MINUTE = 360;
    private TaskManager dumpTaskMgr;
    private TaskManager dumpAllTaskMgr;
    static final int INIT_THREAD_COUNT = 10;
    int total = 0;
    private static final String BETA_TABLE_NAME = "config_info_beta";
    private static final String TAG_TABLE_NAME = "config_info_tag";
    private int retentionDays = 30;

    public DumpService(ConfigInfoPersistService configInfoPersistService, NamespacePersistService namespacePersistService, HistoryConfigInfoPersistService historyConfigInfoPersistService, ConfigInfoAggrPersistService configInfoAggrPersistService, ConfigInfoBetaPersistService configInfoBetaPersistService, ConfigInfoTagPersistService configInfoTagPersistService, MergeDatumService mergeDatumService, ServerMemberManager memberManager) {
        this.configInfoPersistService = configInfoPersistService;
        this.namespacePersistService = namespacePersistService;
        this.historyConfigInfoPersistService = historyConfigInfoPersistService;
        this.configInfoAggrPersistService = configInfoAggrPersistService;
        this.configInfoBetaPersistService = configInfoBetaPersistService;
        this.configInfoTagPersistService = configInfoTagPersistService;
        this.mergeDatumService = mergeDatumService;
        this.memberManager = memberManager;
        this.processor = new DumpProcessor(this.configInfoPersistService, this.configInfoBetaPersistService, this.configInfoTagPersistService);
        this.dumpAllProcessor = new DumpAllProcessor(this.configInfoPersistService);
        this.dumpAllBetaProcessor = new DumpAllBetaProcessor(this.configInfoBetaPersistService);
        this.dumpAllTagProcessor = new DumpAllTagProcessor(this.configInfoTagPersistService);
        this.dumpTaskMgr = new TaskManager("com.alibaba.nacos.server.DumpTaskManager");
        this.dumpTaskMgr.setDefaultTaskProcessor(this.processor);
        this.dumpAllTaskMgr = new TaskManager("com.alibaba.nacos.server.DumpAllTaskManager");
        this.dumpAllTaskMgr.setDefaultTaskProcessor(this.dumpAllProcessor);
        this.dumpAllTaskMgr.addProcessor("dumpAllConfigTask", this.dumpAllProcessor);
        this.dumpAllTaskMgr.addProcessor("dumpAllBetaConfigTask", this.dumpAllBetaProcessor);
        this.dumpAllTaskMgr.addProcessor("dumpAllTagConfigTask", this.dumpAllTagProcessor);
        DynamicDataSource.getInstance().getDataSource();
        NotifyCenter.registerSubscriber((Subscriber)new Subscriber(){

            public void onEvent(Event event) {
                DumpService.this.handleConfigDataChange(event);
            }

            public Class<? extends Event> subscribeType() {
                return ConfigDataChangeEvent.class;
            }
        });
    }

    void handleConfigDataChange(Event event) {
        if (event instanceof ConfigDataChangeEvent) {
            ConfigDataChangeEvent evt = (ConfigDataChangeEvent)event;
            DumpRequest dumpRequest = DumpRequest.create(evt.dataId, evt.group, evt.tenant, evt.lastModifiedTs, NetUtils.localIP());
            dumpRequest.setBeta(evt.isBeta);
            dumpRequest.setBatch(evt.isBatch);
            dumpRequest.setTag(evt.tag);
            this.dump(dumpRequest);
        }
    }

    protected abstract void init() throws Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpOperate() throws NacosException {
        String dumpFileContext = "CONFIG_DUMP_TO_FILE";
        TimerContext.start((String)dumpFileContext);
        try {
            LogUtil.DEFAULT_LOG.warn("DumpService start");
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            try {
                List<ConfigInfoChanged> configList;
                this.dumpAllConfigInfoOnStartup(this.dumpAllProcessor);
                LogUtil.DEFAULT_LOG.info("start clear all config-info-beta.");
                ConfigDiskServiceFactory.getInstance().clearAllBeta();
                if (this.namespacePersistService.isExistTable(BETA_TABLE_NAME)) {
                    this.dumpAllBetaProcessor.process((NacosTask)new DumpAllBetaTask());
                }
                LogUtil.DEFAULT_LOG.info("start clear all config-info-tag.");
                ConfigDiskServiceFactory.getInstance().clearAllTag();
                if (this.namespacePersistService.isExistTable(TAG_TABLE_NAME)) {
                    this.dumpAllTagProcessor.process((NacosTask)new DumpAllTagTask());
                }
                if ((configList = this.configInfoAggrPersistService.findAllAggrGroup()) != null && !configList.isEmpty()) {
                    this.total = configList.size();
                    List<List<ConfigInfoChanged>> splitList = this.mergeDatumService.splitList(configList, 10);
                    for (List<ConfigInfoChanged> list : splitList) {
                        this.mergeDatumService.executeConfigsMerge(list);
                    }
                    LOGGER.info("server start, schedule merge end.");
                }
            }
            catch (Exception e) {
                LogUtil.FATAL_LOG.error("Nacos Server did not start because dumpservice bean construction failure :\n" + e);
                throw new NacosException(500, "Nacos Server did not start because dumpservice bean construction failure :\n" + e.getMessage(), (Throwable)e);
            }
            if (!EnvUtil.getStandaloneMode()) {
                Random random = new Random();
                long initialDelay = random.nextInt(360) + 10;
                LogUtil.DEFAULT_LOG.warn("initialDelay:{}", (Object)initialDelay);
                ConfigExecutor.scheduleConfigTask(new DumpAllProcessorRunner(), initialDelay, 360L, TimeUnit.MINUTES);
                ConfigExecutor.scheduleConfigTask(new DumpAllBetaProcessorRunner(), initialDelay, 360L, TimeUnit.MINUTES);
                ConfigExecutor.scheduleConfigTask(new DumpAllTagProcessorRunner(), initialDelay, 360L, TimeUnit.MINUTES);
                ConfigExecutor.scheduleConfigChangeTask(new DumpChangeConfigWorker(this.configInfoPersistService, this.historyConfigInfoPersistService, currentTime), random.nextInt((int)PropertyUtil.getDumpChangeWorkerInterval()), TimeUnit.MILLISECONDS);
            }
            HistoryConfigCleaner cleaner = HistoryConfigCleanerManager.getHistoryConfigCleaner(HistoryConfigCleanerConfig.getInstance().getActiveHistoryConfigCleaner());
            ConfigExecutor.scheduleConfigTask(new ConfigHistoryClear(cleaner), 10L, 10L, TimeUnit.MINUTES);
        }
        finally {
            TimerContext.end((String)dumpFileContext, (Logger)LogUtil.DUMP_LOG);
        }
    }

    private void dumpAllConfigInfoOnStartup(DumpAllProcessor dumpAllProcessor) {
        try {
            LogUtil.DEFAULT_LOG.info("start clear all config-info.");
            ConfigDiskServiceFactory.getInstance().clearAll();
            dumpAllProcessor.process((NacosTask)new DumpAllTask(true));
        }
        catch (Exception e) {
            LogUtil.FATAL_LOG.error("dump config fail" + e.getMessage());
            throw e;
        }
    }

    public void dump(DumpRequest dumpRequest) {
        if (dumpRequest.isBeta()) {
            this.dumpBeta(dumpRequest.getDataId(), dumpRequest.getGroup(), dumpRequest.getTenant(), dumpRequest.getLastModifiedTs(), dumpRequest.getSourceIp());
        } else if (dumpRequest.isBatch()) {
            this.dumpBatch(dumpRequest.getDataId(), dumpRequest.getGroup(), dumpRequest.getTenant(), dumpRequest.getLastModifiedTs(), dumpRequest.getSourceIp());
        } else if (StringUtils.isNotBlank((String)dumpRequest.getTag())) {
            this.dumpTag(dumpRequest.getDataId(), dumpRequest.getGroup(), dumpRequest.getTenant(), dumpRequest.getTag(), dumpRequest.getLastModifiedTs(), dumpRequest.getSourceIp());
        } else {
            this.dumpFormal(dumpRequest.getDataId(), dumpRequest.getGroup(), dumpRequest.getTenant(), dumpRequest.getLastModifiedTs(), dumpRequest.getSourceIp());
        }
    }

    private void dumpFormal(String dataId, String group, String tenant, long lastModified, String handleIp) {
        String groupKey;
        String taskKey = groupKey = GroupKey2.getKey(dataId, group, tenant);
        this.dumpTaskMgr.addTask((Object)taskKey, new DumpTask(groupKey, false, false, false, null, lastModified, handleIp));
        LogUtil.DUMP_LOG.info("[dump] add formal task. groupKey={}", (Object)groupKey);
    }

    private void dumpBeta(String dataId, String group, String tenant, long lastModified, String handleIp) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        String taskKey = groupKey + "+beta";
        this.dumpTaskMgr.addTask((Object)taskKey, new DumpTask(groupKey, true, false, false, null, lastModified, handleIp));
        LogUtil.DUMP_LOG.info("[dump] add beta task. groupKey={}", (Object)groupKey);
    }

    private void dumpBatch(String dataId, String group, String tenant, long lastModified, String handleIp) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        String taskKey = groupKey + "+batch";
        this.dumpTaskMgr.addTask((Object)taskKey, new DumpTask(groupKey, false, true, false, null, lastModified, handleIp));
        LogUtil.DUMP_LOG.info("[dump] add batch task. groupKey={}", (Object)(dataId + "+" + group));
    }

    private void dumpTag(String dataId, String group, String tenant, String tag, long lastModified, String handleIp) {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        String taskKey = groupKey + "+tag+" + tag;
        this.dumpTaskMgr.addTask((Object)taskKey, new DumpTask(groupKey, false, false, true, tag, lastModified, handleIp));
        LogUtil.DUMP_LOG.info("[dump] add tag task. groupKey={},tag={}", (Object)groupKey, (Object)tag);
    }

    public void dumpAll() {
        this.dumpAllTaskMgr.addTask((Object)"dumpAllConfigTask", new DumpAllTask());
    }

    protected abstract boolean canExecute();

    class DumpAllProcessorRunner
    implements Runnable {
        DumpAllProcessorRunner() {
        }

        @Override
        public void run() {
            DumpService.this.dumpAllTaskMgr.addTask((Object)"dumpAllConfigTask", new DumpAllTask());
        }
    }

    class DumpAllBetaProcessorRunner
    implements Runnable {
        DumpAllBetaProcessorRunner() {
        }

        @Override
        public void run() {
            DumpService.this.dumpAllTaskMgr.addTask((Object)"dumpAllBetaConfigTask", new DumpAllBetaTask());
        }
    }

    class DumpAllTagProcessorRunner
    implements Runnable {
        DumpAllTagProcessorRunner() {
        }

        @Override
        public void run() {
            DumpService.this.dumpAllTaskMgr.addTask((Object)"dumpAllTagConfigTask", new DumpAllTagTask());
        }
    }

    class ConfigHistoryClear
    implements Runnable {
        private HistoryConfigCleaner historyConfigCleaner;

        public ConfigHistoryClear(HistoryConfigCleaner historyConfigCleaner) {
            this.historyConfigCleaner = historyConfigCleaner;
        }

        @Override
        public void run() {
            LOGGER.warn("clearHistoryConfig get scheduled");
            if (DumpService.this.canExecute()) {
                try {
                    LOGGER.warn("clearHistoryConfig is enable in current context, try to run cleaner");
                    this.historyConfigCleaner.cleanHistoryConfig();
                    LOGGER.warn("history config cleaner successfully");
                }
                catch (Throwable e) {
                    LOGGER.error("clearConfigHistory error : {}", (Object)e.toString());
                }
            } else {
                LOGGER.warn("clearHistoryConfig is disable in current context");
            }
        }
    }
}

