/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.embedded;

import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.exception.NacosConfigException;
import com.alibaba.nacos.config.server.model.ConfigInfoAggr;
import com.alibaba.nacos.config.server.model.ConfigInfoChanged;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoAggrPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigRowMapperInjector;
import com.alibaba.nacos.persistence.configuration.condition.ConditionOnEmbeddedStorage;
import com.alibaba.nacos.persistence.datasource.DataSourceService;
import com.alibaba.nacos.persistence.datasource.DynamicDataSource;
import com.alibaba.nacos.persistence.model.Page;
import com.alibaba.nacos.persistence.model.event.DerbyImportEvent;
import com.alibaba.nacos.persistence.repository.PaginationHelper;
import com.alibaba.nacos.persistence.repository.embedded.EmbeddedPaginationHelperImpl;
import com.alibaba.nacos.persistence.repository.embedded.EmbeddedStorageContextHolder;
import com.alibaba.nacos.persistence.repository.embedded.operate.DatabaseOperate;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoAggrMapper;
import com.alibaba.nacos.plugin.datasource.model.MapperContext;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.context.annotation.Conditional;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Conditional(value={ConditionOnEmbeddedStorage.class})
@Service(value="embeddedConfigInfoAggrPersistServiceImpl")
public class EmbeddedConfigInfoAggrPersistServiceImpl
implements ConfigInfoAggrPersistService {
    private DataSourceService dataSourceService;
    private final DatabaseOperate databaseOperate;
    private MapperManager mapperManager;

    public EmbeddedConfigInfoAggrPersistServiceImpl(DatabaseOperate databaseOperate) {
        this.databaseOperate = databaseOperate;
        this.dataSourceService = DynamicDataSource.getInstance().getDataSource();
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
        NotifyCenter.registerToSharePublisher(DerbyImportEvent.class);
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new EmbeddedPaginationHelperImpl(this.databaseOperate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAggrConfigInfo(String dataId, String group, String tenant, String datumId, String appName, String content) {
        Object[] args;
        String appNameTmp = StringUtils.isBlank((CharSequence)appName) ? "" : appName;
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String contentTmp = StringUtils.isBlank((CharSequence)content) ? "" : content;
        Timestamp now = new Timestamp(System.currentTimeMillis());
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        String select = configInfoAggrMapper.select(Collections.singletonList("content"), Arrays.asList("data_id", "group_id", "tenant_id", "datum_id"));
        String insert = configInfoAggrMapper.insert(Arrays.asList("data_id", "group_id", "tenant_id", "datum_id", "app_name", "content", "gmt_modified"));
        String update = configInfoAggrMapper.update(Arrays.asList("content", "gmt_modified"), Arrays.asList("data_id", "group_id", "tenant_id", "datum_id"));
        String dbContent = (String)this.databaseOperate.queryOne(select, new Object[]{dataId, group, tenantTmp, datumId}, String.class);
        if (Objects.isNull(dbContent)) {
            args = new Object[]{dataId, group, tenantTmp, datumId, appNameTmp, contentTmp, now};
            EmbeddedStorageContextHolder.addSqlContext((String)insert, (Object[])args);
        } else if (!dbContent.equals(content)) {
            args = new Object[]{contentTmp, now, dataId, group, tenantTmp, datumId};
            EmbeddedStorageContextHolder.addSqlContext((String)update, (Object[])args);
        }
        try {
            boolean result = this.databaseOperate.update(EmbeddedStorageContextHolder.getCurrentSqlContext());
            if (!result) {
                throw new NacosConfigException("[Merge] Configuration release failed");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            EmbeddedStorageContextHolder.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean batchPublishAggr(String dataId, String group, String tenant, Map<String, String> datumMap, String appName) {
        try {
            Boolean isPublishOk = false;
            for (Map.Entry<String, String> entry : datumMap.entrySet()) {
                this.addAggrConfigInfo(dataId, group, tenant, entry.getKey(), appName, entry.getValue());
            }
            isPublishOk = this.databaseOperate.update(EmbeddedStorageContextHolder.getCurrentSqlContext());
            if (isPublishOk == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = isPublishOk;
            return bl;
        }
        finally {
            EmbeddedStorageContextHolder.cleanAllContext();
        }
    }

    @Override
    public int aggrConfigInfoCount(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        String sql = configInfoAggrMapper.count(Arrays.asList("data_id", "group_id", "tenant_id"));
        Integer result = (Integer)this.databaseOperate.queryOne(sql, new Object[]{dataId, group, tenantTmp}, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("aggrConfigInfoCount error");
        }
        return result;
    }

    @Override
    public Page<ConfigInfoAggr> findConfigInfoAggrByPage(String dataId, String group, String tenant, int pageNo, int pageSize) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        int startRow = (pageNo - 1) * pageSize;
        String sqlCountRows = configInfoAggrMapper.select(Collections.singletonList("count(*)"), Arrays.asList("data_id", "group_id", "tenant_id"));
        MapperContext context = new MapperContext();
        context.putWhereParameter("dataId", (Object)dataId);
        context.putWhereParameter("groupId", (Object)group);
        context.putWhereParameter("tenantId", (Object)tenantTmp);
        context.setStartRow(startRow);
        context.setPageSize(pageSize);
        MapperResult mapperResult = configInfoAggrMapper.findConfigInfoAggrByPageFetchRows(context);
        String sqlFetchRows = mapperResult.getSql();
        Object[] sqlFetchArgs = mapperResult.getParamList().toArray();
        PaginationHelper helper = this.createPaginationHelper();
        return helper.fetchPageLimit(sqlCountRows, new Object[]{dataId, group, tenantTmp}, sqlFetchRows, sqlFetchArgs, pageNo, pageSize, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_AGGR_ROW_MAPPER);
    }

    @Override
    public List<ConfigInfoChanged> findAllAggrGroup() {
        ConfigInfoAggrMapper configInfoAggrMapper = (ConfigInfoAggrMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info_aggr");
        MapperResult mapperResult = configInfoAggrMapper.findAllAggrGroupByDistinct(null);
        return this.databaseOperate.queryMany(mapperResult.getSql(), EMPTY_ARRAY, (RowMapper)ConfigRowMapperInjector.CONFIG_INFO_CHANGED_ROW_MAPPER);
    }
}

