/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.aspect;

import com.alibaba.nacos.api.config.remote.request.ConfigBatchListenRequest;
import com.alibaba.nacos.api.config.remote.request.ConfigPublishRequest;
import com.alibaba.nacos.api.config.remote.request.ConfigQueryRequest;
import com.alibaba.nacos.api.config.remote.request.ConfigRemoveRequest;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.config.server.monitor.MetricsMonitor;
import com.alibaba.nacos.config.server.service.ConfigCacheService;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.RequestUtil;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class RequestLogAspect {
    private static final String CLIENT_INTERFACE_PUBLISH_SINGLE_CONFIG = "execution(* com.alibaba.nacos.config.server.controller.ConfigController.publishConfig(..)) && args(request,response,dataId,group,tenant,content,..)";
    private static final String CLIENT_INTERFACE_PUBLISH_SINGLE_CONFIG_RPC = "execution(* com.alibaba.nacos.core.remote.RequestHandler.handleRequest(..)) && target(com.alibaba.nacos.config.server.remote.ConfigPublishRequestHandler) && args(request,meta)";
    private static final String CLIENT_INTERFACE_GET_CONFIG = "execution(* com.alibaba.nacos.config.server.controller.ConfigController.getConfig(..)) && args(request,response,dataId,group,tenant,..)";
    private static final String CLIENT_INTERFACE_GET_CONFIG_RPC = "execution(* com.alibaba.nacos.core.remote.RequestHandler.handleRequest(..))  && target(com.alibaba.nacos.config.server.remote.ConfigQueryRequestHandler) && args(request,meta)";
    private static final String CLIENT_INTERFACE_REMOVE_ALL_CONFIG = "execution(* com.alibaba.nacos.config.server.controller.ConfigController.deleteConfig(..)) && args(request,response,dataId,group,tenant,..)";
    private static final String CLIENT_INTERFACE_REMOVE_ALL_CONFIG_RPC = "execution(* com.alibaba.nacos.core.remote.RequestHandler.handleRequest(..))  && target(com.alibaba.nacos.config.server.remote.ConfigRemoveRequestHandler) && args(request,meta)";
    private static final String CLIENT_INTERFACE_LISTEN_CONFIG_RPC = "execution(* com.alibaba.nacos.core.remote.RequestHandler.handleRequest(..))  && target(com.alibaba.nacos.config.server.remote.ConfigChangeBatchListenRequestHandler) && args(request,meta)";

    @Around(value="execution(* com.alibaba.nacos.core.remote.RequestHandler.handleRequest(..)) && target(com.alibaba.nacos.config.server.remote.ConfigPublishRequestHandler) && args(request,meta)")
    public Object interfacePublishSingleRpc(ProceedingJoinPoint pjp, ConfigPublishRequest request, RequestMeta meta) throws Throwable {
        String md5 = request.getContent() == null ? null : MD5Utils.md5Hex((String)request.getContent(), (String)"UTF-8");
        MetricsMonitor.getPublishMonitor().incrementAndGet();
        AtomicLong rtHolder = new AtomicLong();
        Object retVal = this.logClientRequestRpc("publish", pjp, (Request)request, meta, request.getDataId(), request.getGroup(), request.getTenant(), md5, rtHolder);
        MetricsMonitor.getWriteConfigRpcRtTimer().record(rtHolder.get(), TimeUnit.MILLISECONDS);
        return retVal;
    }

    @Around(value="execution(* com.alibaba.nacos.config.server.controller.ConfigController.publishConfig(..)) && args(request,response,dataId,group,tenant,content,..)")
    public Object interfacePublishSingle(ProceedingJoinPoint pjp, HttpServletRequest request, HttpServletResponse response, String dataId, String group, String tenant, String content) throws Throwable {
        String md5 = content == null ? null : MD5Utils.md5Hex((String)content, (String)"UTF-8");
        MetricsMonitor.getPublishMonitor().incrementAndGet();
        AtomicLong rtHolder = new AtomicLong();
        Object retVal = this.logClientRequest("publish", pjp, request, response, dataId, group, tenant, md5, rtHolder);
        MetricsMonitor.getWriteConfigRtTimer().record(rtHolder.get(), TimeUnit.MILLISECONDS);
        return retVal;
    }

    @Around(value="execution(* com.alibaba.nacos.config.server.controller.ConfigController.deleteConfig(..)) && args(request,response,dataId,group,tenant,..)")
    public Object interfaceRemoveAll(ProceedingJoinPoint pjp, HttpServletRequest request, HttpServletResponse response, String dataId, String group, String tenant) throws Throwable {
        return this.logClientRequest("remove", pjp, request, response, dataId, group, tenant, null, null);
    }

    @Around(value="execution(* com.alibaba.nacos.core.remote.RequestHandler.handleRequest(..))  && target(com.alibaba.nacos.config.server.remote.ConfigRemoveRequestHandler) && args(request,meta)")
    public Object interfaceRemoveAllRpc(ProceedingJoinPoint pjp, ConfigRemoveRequest request, RequestMeta meta) throws Throwable {
        return this.logClientRequestRpc("remove", pjp, (Request)request, meta, request.getDataId(), request.getGroup(), request.getTenant(), null, null);
    }

    @Around(value="execution(* com.alibaba.nacos.config.server.controller.ConfigController.getConfig(..)) && args(request,response,dataId,group,tenant,..)")
    public Object interfaceGetConfig(ProceedingJoinPoint pjp, HttpServletRequest request, HttpServletResponse response, String dataId, String group, String tenant) throws Throwable {
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        String md5 = ConfigCacheService.getContentMd5(groupKey);
        MetricsMonitor.getConfigMonitor().incrementAndGet();
        AtomicLong rtHolder = new AtomicLong();
        Object retVal = this.logClientRequest("get", pjp, request, response, dataId, group, tenant, md5, rtHolder);
        MetricsMonitor.getReadConfigRtTimer().record(rtHolder.get(), TimeUnit.MILLISECONDS);
        return retVal;
    }

    @Around(value="execution(* com.alibaba.nacos.core.remote.RequestHandler.handleRequest(..))  && target(com.alibaba.nacos.config.server.remote.ConfigQueryRequestHandler) && args(request,meta)")
    public Object interfaceGetConfigRpc(ProceedingJoinPoint pjp, ConfigQueryRequest request, RequestMeta meta) throws Throwable {
        String groupKey = GroupKey2.getKey(request.getDataId(), request.getGroup(), request.getTenant());
        String md5 = ConfigCacheService.getContentMd5(groupKey);
        MetricsMonitor.getConfigMonitor().incrementAndGet();
        AtomicLong rtHolder = new AtomicLong();
        Object retVal = this.logClientRequestRpc("get", pjp, (Request)request, meta, request.getDataId(), request.getGroup(), request.getTenant(), md5, rtHolder);
        MetricsMonitor.getReadConfigRpcRtTimer().record(rtHolder.get(), TimeUnit.MILLISECONDS);
        return retVal;
    }

    private Object logClientRequest(String requestType, ProceedingJoinPoint pjp, HttpServletRequest request, HttpServletResponse response, String dataId, String group, String tenant, String md5, AtomicLong rtHolder) throws Throwable {
        String requestIp = RequestUtil.getRemoteIp(request);
        String appName = request.getHeader("Client-AppName");
        long st = System.currentTimeMillis();
        Object retVal = pjp.proceed();
        long rt = System.currentTimeMillis() - st;
        if (rtHolder != null) {
            rtHolder.set(rt);
        }
        LogUtil.CLIENT_LOG.info("{}|{}|{}|{}|{}|{}|{}|{}|{}", new Object[]{rt, retVal, requestIp, requestType, dataId, group, tenant, md5, appName});
        return retVal;
    }

    private Object logClientRequestRpc(String requestType, ProceedingJoinPoint pjp, Request request, RequestMeta meta, String dataId, String group, String tenant, String md5, AtomicLong rtHolder) throws Throwable {
        String requestIp = meta.getClientIp();
        String appName = request.getHeader("Client-AppName");
        long st = System.currentTimeMillis();
        Response retVal = (Response)pjp.proceed();
        long rt = System.currentTimeMillis() - st;
        if (rtHolder != null) {
            rtHolder.set(rt);
        }
        LogUtil.CLIENT_LOG.info("{}|{}|{}|{}|{}|{}|{}|{}|{}", new Object[]{rt, retVal.isSuccess() ? retVal.getResultCode() : retVal.getErrorCode(), requestIp, requestType, dataId, group, tenant, md5, appName});
        return retVal;
    }

    @Around(value="execution(* com.alibaba.nacos.core.remote.RequestHandler.handleRequest(..))  && target(com.alibaba.nacos.config.server.remote.ConfigChangeBatchListenRequestHandler) && args(request,meta)")
    public Object interfaceListenConfigRpc(ProceedingJoinPoint pjp, ConfigBatchListenRequest request, RequestMeta meta) throws Throwable {
        MetricsMonitor.getConfigMonitor().incrementAndGet();
        String requestIp = meta.getClientIp();
        String appName = request.getHeader("Client-AppName");
        long st = System.currentTimeMillis();
        Response retVal = (Response)pjp.proceed();
        long rt = System.currentTimeMillis() - st;
        LogUtil.CLIENT_LOG.info("{}|{}|{}|{}|{}|{}|{}|{}|{}", new Object[]{rt, retVal.isSuccess() ? retVal.getResultCode() : retVal.getErrorCode(), requestIp, "listen", request.getConfigListenContexts().size(), request.isListen(), "", "", appName});
        return retVal;
    }
}

